/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.XMLResourceBundle;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;

public class XMLBundleControl
extends ResourceBundle.Control {
    private static final String FORMAT = "xml";

    @Override
    public List<String> getFormats(String aBaseName) {
        Objects.requireNonNull(aBaseName);
        return Arrays.asList(FORMAT);
    }

    @Override
    public ResourceBundle newBundle(String aBaseName, Locale aLocale, String aFormat, ClassLoader aClassLoader, boolean aReload) throws IllegalAccessException, InstantiationException, IOException {
        ResourceBundle bundle = null;
        this.checkForNull(aBaseName, aLocale, aFormat, aClassLoader);
        if (aFormat.equals(FORMAT)) {
            String bundleName = this.toBundleName(aBaseName, aLocale);
            String resourceName = this.toResourceName(bundleName, aFormat);
            if (aReload) {
                URL url = aClassLoader.getResource(resourceName);
                if (url != null) {
                    URLConnection connection = url.openConnection();
                    connection.setUseCaches(false);
                    bundle = this.makeBundle(connection.getInputStream());
                }
            } else {
                InputStream bundleStream = aClassLoader.getResourceAsStream(resourceName);
                bundle = this.makeBundle(bundleStream);
            }
        }
        return bundle;
    }

    private ResourceBundle makeBundle(InputStream aInputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(aInputStream);
        XMLResourceBundle bundle = new XMLResourceBundle(bufferedInputStream);
        bufferedInputStream.close();
        return bundle;
    }

    private void checkForNull(Object ... aVarargs) {
        for (Object arg : aVarargs) {
            Objects.requireNonNull(arg);
        }
    }
}

