/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class XmlUtils {
    private static final int DEFAULT_INDENTATION = 2;
    private static final String YES = "yes";

    private XmlUtils() {
    }

    public static String format(String aUnformattedXmlString, int aIndentation) throws TransformerConfigurationException, TransformerException {
        StreamSource xmlInput = new StreamSource(new StringReader(aUnformattedXmlString));
        StringWriter stringWriter = new StringWriter();
        StreamResult xmlOutput = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", aIndentation);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", YES);
        transformer.setOutputProperty("indent", YES);
        transformer.transform(xmlInput, xmlOutput);
        xmlOutput.getWriter().toString();
        return xmlOutput.getWriter().toString();
    }

    public static String format(String aUnformattedXmlString) throws TransformerConfigurationException, TransformerException {
        return XmlUtils.format(aUnformattedXmlString, 2);
    }
}

