/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.IOUtils;
import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;
import info.freelibrary.util.RegexFileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class ZipUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipUtils.class, "freelib-utils_messages");
    private static final String WILDCARD = ".*";

    private ZipUtils() {
    }

    public static void zip(File aFileSystemDir, File aOutputZipFile) throws FileNotFoundException, IOException {
        ZipUtils.zip(aFileSystemDir, aOutputZipFile, new RegexFileFilter(WILDCARD), new File[0]);
    }

    public static void zip(File aFileSystemDir, File aOutputZipFile, File ... aIncludesFileList) throws FileNotFoundException, IOException {
        ZipUtils.zip(aFileSystemDir, aOutputZipFile, new RegexFileFilter(WILDCARD), aIncludesFileList);
    }

    public static void zip(File aFileSystemDir, File aOutputZipFile, FilenameFilter aIncludesFilter, File ... aIncludesFileList) throws FileNotFoundException, IOException {
        ZipOutputStream zipFileStream = new ZipOutputStream(new FileOutputStream(aOutputZipFile));
        String parentDirPath = aFileSystemDir.getParentFile().getAbsolutePath();
        ZipUtils.dirToZip(aFileSystemDir, parentDirPath, aIncludesFilter, zipFileStream);
        for (File file : aIncludesFileList) {
            String path = File.separator + aFileSystemDir.getName() + File.separator + file.getName();
            ZipEntry entry = new ZipEntry(path);
            FileInputStream inFileStream = new FileInputStream(file);
            zipFileStream.putNextEntry(entry);
            IOUtils.copyStream(inFileStream, (OutputStream)zipFileStream);
            IOUtils.closeQuietly(inFileStream);
        }
        IOUtils.closeQuietly(zipFileStream);
    }

    private static void dirToZip(File aSourceDir, String aRootDir, FilenameFilter aFilter, ZipOutputStream aZipStream) throws IOException {
        for (File inFile : aSourceDir.listFiles()) {
            if (inFile.isDirectory()) {
                LOGGER.debug("UTIL-027", (Object)inFile);
                ZipUtils.dirToZip(inFile, aRootDir, aFilter, aZipStream);
                continue;
            }
            if (!aFilter.accept(inFile.getParentFile(), inFile.getName())) continue;
            String relativePath = aSourceDir.getAbsolutePath().replace(aRootDir, "");
            ZipEntry entry = new ZipEntry(relativePath + File.separator + inFile.getName());
            FileInputStream inFileStream = new FileInputStream(inFile);
            aZipStream.putNextEntry(entry);
            IOUtils.copyStream(inFileStream, (OutputStream)aZipStream);
            IOUtils.closeQuietly(inFileStream);
        }
    }
}

