/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow;

import info.openmeta.framework.base.context.Context;
import info.openmeta.framework.base.context.ContextHolder;
import info.openmeta.framework.base.enums.AccessType;
import info.openmeta.framework.base.exception.IllegalArgumentException;
import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.orm.jdbc.JdbcService;
import info.openmeta.starter.flow.entity.FlowConfig;
import info.openmeta.starter.flow.entity.FlowTrigger;
import info.openmeta.starter.flow.enums.TriggerEventType;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class FlowManager
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(FlowManager.class);
    private static final Map<String, List<FlowTrigger>> MODEL_TRIGGER_MAP = new ConcurrentHashMap<String, List<FlowTrigger>>();
    private static final Map<Long, FlowTrigger> CRON_TRIGGER_MAP = new ConcurrentHashMap<Long, FlowTrigger>();
    private static final Map<Long, FlowConfig> FLOW_MAP = new ConcurrentHashMap<Long, FlowConfig>();
    @Autowired
    private JdbcService<?> jdbcService;

    public void afterPropertiesSet() {
        MODEL_TRIGGER_MAP.clear();
        CRON_TRIGGER_MAP.clear();
        FLOW_MAP.clear();
        ContextHolder.setContext((Context)new Context());
        List triggers = this.jdbcService.selectMetaEntityList(FlowTrigger.class, null);
        triggers.forEach(trigger -> {
            MODEL_TRIGGER_MAP.computeIfAbsent(trigger.getTriggeredModel(), k -> new ArrayList()).add(trigger);
            if (trigger.getCronId() != null && trigger.getCronId() > 0L) {
                CRON_TRIGGER_MAP.put(trigger.getCronId(), (FlowTrigger)((Object)trigger));
            }
        });
        List flowConfigs = this.jdbcService.selectMetaEntityList(FlowConfig.class, null);
        flowConfigs.forEach(flowConfig -> FLOW_MAP.put(flowConfig.getId(), (FlowConfig)((Object)flowConfig)));
    }

    public static FlowConfig getFlowById(Long flowId) {
        return FLOW_MAP.get(flowId);
    }

    public static FlowTrigger getTriggerByCronId(Long cronId) {
        return CRON_TRIGGER_MAP.get(cronId);
    }

    private static List<FlowTrigger> getModelFlowTriggers(String triggerModel) {
        List<FlowTrigger> flowTriggers = MODEL_TRIGGER_MAP.get(triggerModel);
        Assert.notEmpty(flowTriggers, (String)"The model {0} does not define any triggers!", (Object[])new Object[]{triggerModel});
        return flowTriggers;
    }

    public static FlowTrigger getTriggerByCode(String triggerModel, @NotNull String triggerCode) {
        List<FlowTrigger> flowTriggers = FlowManager.getModelFlowTriggers(triggerModel);
        for (FlowTrigger flowTrigger : flowTriggers) {
            if (!triggerCode.equals(flowTrigger.getTriggerCode())) continue;
            return flowTrigger;
        }
        throw new IllegalArgumentException("The model {0} does not define a trigger with code {1}!", new Object[]{triggerModel, triggerCode});
    }

    public static FlowTrigger getTriggerByCode(String triggerModel, @NotNull String triggerCode, @NotNull TriggerEventType eventType) {
        List<FlowTrigger> flowTriggers = FlowManager.getModelFlowTriggers(triggerModel);
        for (FlowTrigger flowTrigger : flowTriggers) {
            if (!triggerCode.equals(flowTrigger.getTriggerCode()) || !eventType.equals((Object)flowTrigger.getEventType())) continue;
            return flowTrigger;
        }
        throw new IllegalArgumentException("The model {0} does not define a {1} trigger with code {2}!", new Object[]{triggerModel, eventType.getType(), triggerCode});
    }

    public static List<FlowTrigger> getTriggersByChangeEvent(String triggerModel, @NotNull AccessType accessType, Set<String> updateFields) {
        List<FlowTrigger> flowTriggers = MODEL_TRIGGER_MAP.get(triggerModel);
        if (CollectionUtils.isEmpty(flowTriggers)) {
            return Collections.emptyList();
        }
        return flowTriggers.stream().filter(flowTrigger -> FlowManager.isTriggerMatch(flowTrigger, accessType, updateFields)).collect(Collectors.toList());
    }

    private static boolean isTriggerMatch(FlowTrigger flowTrigger, AccessType accessType, Set<String> updateFields) {
        TriggerEventType eventType;
        block6: {
            block8: {
                block7: {
                    eventType = flowTrigger.getEventType();
                    if (TriggerEventType.CHANGED_EVENT.equals((Object)eventType)) {
                        return true;
                    }
                    if (AccessType.CREATE.equals((Object)accessType)) {
                        return TriggerEventType.CREATE_EVENT.equals((Object)eventType) || TriggerEventType.CREATE_OR_UPDATE.equals((Object)eventType);
                    }
                    if (!AccessType.UPDATE.equals((Object)accessType)) break block6;
                    if (CollectionUtils.isEmpty(flowTrigger.getTriggeredFields()) || CollectionUtils.isEmpty(updateFields)) break block7;
                    if (!updateFields.stream().anyMatch(flowTrigger.getTriggeredFields()::contains)) break block8;
                }
                return TriggerEventType.UPDATE_EVENT.equals((Object)eventType) || TriggerEventType.CREATE_OR_UPDATE.equals((Object)eventType);
            }
            return false;
        }
        if (AccessType.DELETE.equals((Object)accessType)) {
            return TriggerEventType.DELETE_EVENT.equals((Object)eventType);
        }
        return false;
    }
}

