/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.action;

import com.fasterxml.jackson.databind.JsonNode;
import info.openmeta.framework.base.exception.FlowException;
import info.openmeta.framework.base.exception.IllegalArgumentException;
import info.openmeta.framework.base.exception.JSONException;
import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.base.utils.JsonMapper;
import info.openmeta.framework.orm.compute.ComputeUtils;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.action.ActionExceptionPolicy;
import info.openmeta.starter.flow.entity.FlowAction;
import info.openmeta.starter.flow.enums.ActionExceptionSignal;
import info.openmeta.starter.flow.enums.ActionExceptionType;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(ActionExceptionResolver.class);

    private ActionExceptionResolver() {
    }

    public static void resolveActionException(FlowAction flowAction, ActionContext actionContext) {
        ActionExceptionPolicy exceptionPolicy = ActionExceptionResolver.getActionExceptionPolicy(flowAction);
        if (exceptionPolicy == null) {
            return;
        }
        Object value = actionContext.get(flowAction.getCode());
        boolean throwExceptionSignal = ActionExceptionResolver.checkResultForException(value, exceptionPolicy);
        if (!throwExceptionSignal) {
            return;
        }
        ActionExceptionSignal exceptionSignal = exceptionPolicy.getExceptionSignal();
        String exceptionMessage = ComputeUtils.stringInterpolation((String)exceptionPolicy.getExceptionMessage(), actionContext.getEnv());
        ActionExceptionResolver.processExceptionSignal(flowAction, exceptionSignal, exceptionMessage, actionContext);
    }

    public static void processExceptionSignal(FlowAction flowAction, ActionExceptionSignal exceptionSignal, String exceptionMessage, ActionContext actionContext) {
        if (ActionExceptionSignal.THROW_EXCEPTION.equals((Object)exceptionSignal)) {
            throw new FlowException("The result of flow action {0} is an exception: {1}", new Object[]{flowAction.getName(), exceptionMessage});
        }
        actionContext.setExceptionSignal(exceptionSignal);
        if (StringUtils.isNotBlank((CharSequence)exceptionMessage)) {
            log.warn("The result of flow action {} is an exception: {}, will {}", new Object[]{flowAction.getName(), exceptionMessage, exceptionSignal.getName()});
        }
    }

    private static ActionExceptionPolicy getActionExceptionPolicy(FlowAction flowAction) {
        ActionExceptionPolicy exceptionPolicy;
        if (flowAction.getExceptionPolicy() == null) {
            return null;
        }
        try {
            exceptionPolicy = (ActionExceptionPolicy)JsonMapper.jsonNodeToObject((JsonNode)flowAction.getExceptionPolicy(), ActionExceptionPolicy.class);
        }
        catch (JSONException e) {
            throw new JSONException("The exception handling strategy for flow action {0} encountered an exception: {1}", new Object[]{flowAction.getName(), flowAction, e});
        }
        if (exceptionPolicy == null) {
            return null;
        }
        Assert.notNull((Object)((Object)exceptionPolicy.getExceptionWhen()), (String)"The `exceptionWhen` of exception handling strategy cannot be empty: {0}", (Object[])new Object[]{exceptionPolicy});
        Assert.notNull((Object)((Object)exceptionPolicy.getExceptionSignal()), (String)"The `exceptionSignal` of exception handling strategy cannot be empty: {0}", (Object[])new Object[]{exceptionPolicy});
        if (ActionExceptionSignal.THROW_EXCEPTION.equals((Object)exceptionPolicy.getExceptionSignal())) {
            Assert.notBlank((String)exceptionPolicy.getExceptionMessage(), (String)"The exception handling strategy is configured to throw an exception, so the exception message configuration cannot be empty: {0}", (Object[])new Object[]{exceptionPolicy});
        }
        return exceptionPolicy;
    }

    private static boolean checkResultForException(Object value, ActionExceptionPolicy exceptionPolicy) {
        return switch (exceptionPolicy.getExceptionWhen()) {
            case ActionExceptionType.RESULT_IS_EMPTY -> ActionExceptionResolver.checkResultIsEmpty(value);
            case ActionExceptionType.RESULT_IS_EMPTY_OR_ZERO -> ActionExceptionResolver.checkResultIsEmpty(value) || value.equals(0) || value.equals(0L);
            case ActionExceptionType.RESULT_IS_NOT_EMPTY -> !ActionExceptionResolver.checkResultIsEmpty(value);
            case ActionExceptionType.RESULT_IS_FALSE -> value == null || Boolean.FALSE.equals(value);
            case ActionExceptionType.RESULT_IS_TRUE -> Boolean.TRUE.equals(value);
            default -> throw new IllegalArgumentException("Unsupported exception strategy condition: {0}", new Object[]{exceptionPolicy.getExceptionWhen()});
        };
    }

    private static boolean checkResultIsEmpty(Object value) {
        return value == null || value instanceof String && ((String)value).isEmpty() || value instanceof Collection && ((Collection)value).isEmpty() || value instanceof Map && ((Map)value).isEmpty();
    }
}

