/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.action;

import com.fasterxml.jackson.databind.JsonNode;
import info.openmeta.framework.base.exception.FlowException;
import info.openmeta.framework.base.exception.JSONException;
import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.base.utils.JsonMapper;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.action.ActionExceptionResolver;
import info.openmeta.starter.flow.action.ActionProcessor;
import info.openmeta.starter.flow.action.params.ActionParams;
import info.openmeta.starter.flow.entity.FlowAction;
import info.openmeta.starter.flow.enums.FlowActionType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Component;

@Component
public class ActionFactory<T extends ActionParams> {
    private static final Logger log = LoggerFactory.getLogger(ActionFactory.class);
    private final Map<FlowActionType, ActionProcessor<T>> ACTION_PROCESSOR_MAP = new HashMap<FlowActionType, ActionProcessor<T>>();

    @Autowired
    public ActionFactory(List<ActionProcessor<T>> actionProcessors) {
        for (ActionProcessor<T> actionProcessor : actionProcessors) {
            this.ACTION_PROCESSOR_MAP.put(actionProcessor.getActionType(), actionProcessor);
        }
    }

    public void executeActionProcessor(FlowAction flowAction, ActionContext actionContext) {
        ActionParams actionParams;
        ActionProcessor<ActionParams> actionProcessor = this.ACTION_PROCESSOR_MAP.get((Object)flowAction.getActionType());
        Assert.notNull(actionProcessor, (String)"The processor for flow action {0} does not exist!", (Object[])new Object[]{flowAction.getActionType()});
        Class<T> paramsClass = actionProcessor.getParamsClass();
        try {
            actionParams = (ActionParams)JsonMapper.jsonNodeToObject((JsonNode)flowAction.getActionParams(), paramsClass);
        }
        catch (JSONException e) {
            throw new JSONException("Failed to convert the parameters of flow action {0} to an instance of {1}: {2}", new Object[]{flowAction, paramsClass.getSimpleName(), e.getMessage()});
        }
        Assert.notNull((Object)actionParams, (String)"The parameters for flow action {0} cannot be null", (Object[])new Object[]{flowAction});
        actionProcessor.validateParams(flowAction, actionParams);
        try {
            actionProcessor.execute(flowAction, actionParams, actionContext);
        }
        catch (DuplicateKeyException e) {
            throw new FlowException("Failed to execute flow action due to unique index constraint violation: {0} ", new Object[]{flowAction, e});
        }
        catch (Exception e) {
            throw new FlowException("Failed to execute flow action {0}! \n ActionParams: {} \n ActionContext: {}", new Object[]{flowAction, actionParams, actionContext, e});
        }
        ActionExceptionResolver.resolveActionException(flowAction, actionContext);
    }
}

