/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.action.processors;

import info.openmeta.framework.base.context.ContextHolder;
import info.openmeta.framework.base.utils.Assert;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.action.ActionProcessor;
import info.openmeta.starter.flow.action.params.AsyncTaskParams;
import info.openmeta.starter.flow.entity.FlowAction;
import info.openmeta.starter.flow.enums.FlowActionType;
import info.openmeta.starter.flow.message.FlowAsyncTaskProducer;
import info.openmeta.starter.flow.message.dto.FlowAsyncTaskMessage;
import info.openmeta.starter.flow.utils.FlowUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsyncTaskAction
implements ActionProcessor<AsyncTaskParams> {
    private static final Logger log = LoggerFactory.getLogger(AsyncTaskAction.class);
    @Autowired
    private FlowAsyncTaskProducer flowAsyncTaskProducer;

    @Override
    public FlowActionType getActionType() {
        return FlowActionType.ASYNC_TASK;
    }

    @Override
    public Class<AsyncTaskParams> getParamsClass() {
        return AsyncTaskParams.class;
    }

    @Override
    public void validateParams(FlowAction flowAction, AsyncTaskParams actionParams) {
        Assert.notBlank((String)actionParams.getAsyncTaskHandlerCode(), (String)"The async task handler code {0} cannot be empty!", (Object[])new Object[]{flowAction.getName()});
    }

    @Override
    public void execute(FlowAction flowAction, AsyncTaskParams actionParams, ActionContext actionContext) {
        Map<String, Object> asyncTaskParams = FlowUtils.resolveDataTemplate(actionParams.getDataTemplate(), actionContext);
        FlowAsyncTaskMessage flowAsyncTaskMessage = new FlowAsyncTaskMessage();
        flowAsyncTaskMessage.setFlowId(flowAction.getFlowId());
        flowAsyncTaskMessage.setNodeId(flowAction.getNodeId());
        flowAsyncTaskMessage.setActionId(flowAction.getId());
        flowAsyncTaskMessage.setAsyncTaskHandlerCode(actionParams.getAsyncTaskHandlerCode());
        flowAsyncTaskMessage.setAsyncTaskParams(asyncTaskParams);
        flowAsyncTaskMessage.setContext(ContextHolder.getContext());
        this.flowAsyncTaskProducer.sendFlowTask(flowAsyncTaskMessage);
    }
}

