/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.action.processors;

import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.base.utils.StringTools;
import info.openmeta.framework.orm.domain.Filters;
import info.openmeta.framework.orm.service.ModelService;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.action.ActionProcessor;
import info.openmeta.starter.flow.action.params.DeleteDataParams;
import info.openmeta.starter.flow.entity.FlowAction;
import info.openmeta.starter.flow.enums.FlowActionType;
import info.openmeta.starter.flow.utils.FlowUtils;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DeleteDataAction
implements ActionProcessor<DeleteDataParams> {
    private static final Logger log = LoggerFactory.getLogger(DeleteDataAction.class);
    @Autowired
    private ModelService<? extends Serializable> modelService;

    @Override
    public FlowActionType getActionType() {
        return FlowActionType.DELETE_DATA;
    }

    @Override
    public Class<DeleteDataParams> getParamsClass() {
        return DeleteDataParams.class;
    }

    @Override
    public void validateParams(FlowAction flowAction, DeleteDataParams actionParams) {
        Assert.notBlank((String)actionParams.getModelName(), (String)"The model name for Delete Action {0} cannot be empty!", (Object[])new Object[]{flowAction.getName()});
        Assert.notTrue((Boolean)(StringUtils.isBlank((CharSequence)actionParams.getPkVariable()) && Filters.isEmpty((Filters)actionParams.getFilters()) ? 1 : 0), (String)"In the parameter configuration of the Delete Action {0}, at least the primary key parameter or the filter condition for deleting data must be specified.", (Object[])new Object[]{flowAction.getName()});
    }

    @Override
    public void execute(FlowAction flowAction, DeleteDataParams actionParams, ActionContext actionContext) {
        String pkVariable = actionParams.getPkVariable();
        Filters deleteFilters = null;
        if (StringTools.isVariable((String)pkVariable)) {
            Collection<?> ids = FlowUtils.getIdsFromPkVariable(flowAction, pkVariable, actionContext);
            if (CollectionUtils.isEmpty(ids)) {
                return;
            }
            deleteFilters = Filters.in((String)"id", ids);
        }
        if (!Filters.isEmpty((Filters)actionParams.getFilters())) {
            Filters clonedFilters = actionParams.getFilters().deepCopy();
            FlowUtils.resolveFilterValue(actionParams.getModelName(), clonedFilters, actionContext);
            deleteFilters = Filters.merge((Filters[])new Filters[]{deleteFilters, clonedFilters});
        }
        if (Filters.isEmpty(deleteFilters)) {
            return;
        }
        this.modelService.deleteByFilters(actionParams.getModelName(), deleteFilters);
    }
}

