/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.action.processors;

import info.openmeta.framework.base.exception.IllegalArgumentException;
import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.base.utils.StringTools;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.action.ActionProcessor;
import info.openmeta.starter.flow.action.params.ExtractTransformParams;
import info.openmeta.starter.flow.entity.FlowAction;
import info.openmeta.starter.flow.enums.FlowActionType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ExtractTransformAction
implements ActionProcessor<ExtractTransformParams> {
    private static final Logger log = LoggerFactory.getLogger(ExtractTransformAction.class);

    @Override
    public FlowActionType getActionType() {
        return FlowActionType.EXTRACT_TRANSFORM;
    }

    @Override
    public Class<ExtractTransformParams> getParamsClass() {
        return ExtractTransformParams.class;
    }

    @Override
    public void validateParams(FlowAction flowAction, ExtractTransformParams actionParams) {
        Assert.notBlank((String)actionParams.getCollectionVariable(), (String)"The collection parameter configuration for Extract-Transform Action {0} cannot be empty!", (Object[])new Object[]{flowAction.getName()});
        Assert.isTrue((Boolean)StringTools.isVariable((String)actionParams.getCollectionVariable()), (String)"The parameter {0} for Extract-Transform Action {1} must be identified with `#{}`.", (Object[])new Object[]{actionParams.getCollectionVariable(), flowAction.getName()});
        Assert.notBlank((String)actionParams.getItemKey(), (String)"The item key configuration for Extract-Transform Action {0} cannot be empty!", (Object[])new Object[]{flowAction.getName()});
    }

    @Override
    public void execute(FlowAction flowAction, ExtractTransformParams actionParams, ActionContext actionContext) {
        Object variableValue = StringTools.extractVariable((String)actionParams.getCollectionVariable(), actionContext.getEnv());
        if (variableValue == null || variableValue instanceof Collection && CollectionUtils.isEmpty((Collection)((Collection)variableValue))) {
            actionContext.put(flowAction.getCode(), Collections.emptySet());
        } else if (variableValue instanceof Collection) {
            HashSet result = new HashSet();
            ((Collection)variableValue).forEach(row -> {
                Object val;
                if (row instanceof Map && (val = ((Map)row).get(actionParams.getItemKey())) != null) {
                    result.add(val);
                }
            });
            actionContext.put(flowAction.getCode(), result);
        } else {
            throw new IllegalArgumentException("The value of the data source variable {0} for Extract-Transform Action {1} is not a collection: {2}.\n", new Object[]{actionParams.getCollectionVariable(), flowAction.getName(), variableValue});
        }
    }
}

