/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.action.processors;

import info.openmeta.framework.base.utils.Assert;
import info.openmeta.starter.flow.FlowAutomation;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.action.ActionProcessor;
import info.openmeta.starter.flow.action.params.TriggerSubflowParams;
import info.openmeta.starter.flow.entity.FlowAction;
import info.openmeta.starter.flow.enums.FlowActionType;
import info.openmeta.starter.flow.utils.FlowUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TriggerSubflowAction
implements ActionProcessor<TriggerSubflowParams> {
    private static final Logger log = LoggerFactory.getLogger(TriggerSubflowAction.class);
    @Autowired
    @Lazy
    private FlowAutomation automation;

    @Override
    public FlowActionType getActionType() {
        return FlowActionType.TRIGGER_SUBFLOW;
    }

    @Override
    public Class<TriggerSubflowParams> getParamsClass() {
        return TriggerSubflowParams.class;
    }

    @Override
    public void validateParams(FlowAction flowAction, TriggerSubflowParams actionParams) {
        Assert.notBlank((String)actionParams.getSubflowTriggerModel(), (String)"The subflow trigger model for Action {0} cannot be blank!", (Object[])new Object[]{flowAction.getName()});
        Assert.notBlank((String)actionParams.getSubflowTriggerCode(), (String)"The subflow trigger code for Action {0} cannot be blank!", (Object[])new Object[]{flowAction.getName()});
    }

    @Override
    public void execute(FlowAction flowAction, TriggerSubflowParams actionParams, ActionContext actionContext) {
        Map<String, Object> subflowParams = FlowUtils.resolveDataTemplate(actionParams.getDataTemplate(), actionContext);
        Object result = this.automation.subflowEvent(actionParams.getSubflowTriggerModel(), actionParams.getSubflowTriggerCode(), subflowParams);
        actionContext.put(flowAction.getCode(), result);
    }
}

