/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.message;

import info.openmeta.framework.base.context.Context;
import info.openmeta.framework.base.context.ContextHolder;
import info.openmeta.framework.orm.changelog.message.dto.ChangeLogMessage;
import info.openmeta.starter.flow.FlowAutomation;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="${rocketmq.topics.change-log.topic}", consumerGroup="${rocketmq.topics.change-log.flow-group}")
public class ChangeLogFlowConsumer
implements RocketMQListener<ChangeLogMessage> {
    @Autowired
    private FlowAutomation flowAutomation;

    public void onMessage(ChangeLogMessage changeLogMessage) {
        ContextHolder.setContext((Context)changeLogMessage.getContext());
        if (ContextHolder.getContext().isTriggerFlow()) {
            this.flowAutomation.triggerAsyncFlows(changeLogMessage.getChangeLogs());
        }
    }
}

