/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow;

import info.openmeta.framework.base.constant.TimeConstant;
import info.openmeta.framework.base.context.ContextHolder;
import info.openmeta.framework.base.enums.AccessType;
import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.orm.changelog.message.dto.ChangeLog;
import info.openmeta.framework.orm.compute.ComputeUtils;
import info.openmeta.framework.orm.utils.MapUtils;
import info.openmeta.starter.cron.message.dto.CronTaskMessage;
import info.openmeta.starter.flow.FlowManager;
import info.openmeta.starter.flow.entity.FlowConfig;
import info.openmeta.starter.flow.entity.FlowTrigger;
import info.openmeta.starter.flow.enums.TriggerEventType;
import info.openmeta.starter.flow.message.FlowEventProducer;
import info.openmeta.starter.flow.message.dto.FlowEventMessage;
import info.openmeta.starter.flow.service.FlowConfigService;
import info.openmeta.starter.flow.vo.TriggerEventVO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class FlowAutomation {
    private static final Logger log = LoggerFactory.getLogger(FlowAutomation.class);
    @Autowired
    private FlowEventProducer flowEventProducer;
    @Autowired
    private FlowConfigService flowConfigService;

    @Transactional(rollbackFor={Exception.class})
    public void triggerSyncFlows(List<ChangeLog> changeLogs) {
        this.triggerFlowByChangeLog(changeLogs, true);
    }

    public void triggerAsyncFlows(List<ChangeLog> changeLogs) {
        this.triggerFlowByChangeLog(changeLogs, false);
    }

    private List<FlowEventMessage> getEventMessagesByChangeLogs(List<ChangeLog> changeLogs, boolean sync) {
        ArrayList<FlowEventMessage> flowEventMessages = new ArrayList<FlowEventMessage>();
        for (ChangeLog changeLog : changeLogs) {
            String triggerModel = changeLog.getModel();
            Serializable triggerRowId = changeLog.getRowId();
            Set<String> updateFields = AccessType.UPDATE.equals((Object)changeLog.getAccessType()) ? changeLog.getDataAfterChange().keySet() : Collections.emptySet();
            Map triggerParams = AccessType.DELETE.equals((Object)changeLog.getAccessType()) ? changeLog.getDataBeforeChange() : changeLog.getDataAfterChange();
            List<FlowTrigger> flowTriggers = FlowManager.getTriggersByChangeEvent(triggerModel, changeLog.getAccessType(), updateFields);
            flowTriggers.forEach(flowTrigger -> {
                if (!this.validateTriggerCondition((FlowTrigger)((Object)flowTrigger), triggerParams)) {
                    log.debug("The trigger condition {} for Trigger {} is not met; the flow will not be triggered!", (Object)flowTrigger.getTriggerCondition(), (Object)flowTrigger.getTriggerCode());
                    return;
                }
                FlowConfig flowConfig = FlowManager.getFlowById(flowTrigger.getFlowId());
                Assert.notNull((Object)((Object)flowConfig), (String)"Trigger {0} is not yet bound to any flow!", (Object[])new Object[]{flowTrigger.getTriggerCode()});
                FlowEventMessage eventMessage = this.wrapperFlowEventMessage((FlowTrigger)((Object)flowTrigger), flowConfig, triggerRowId, triggerParams);
                flowEventMessages.add(eventMessage);
            });
        }
        return flowEventMessages;
    }

    private FlowEventMessage wrapperFlowEventMessage(FlowTrigger flowTrigger, FlowConfig flowConfig, Serializable rowId, Map<String, Object> params) {
        FlowEventMessage eventMessage = new FlowEventMessage();
        eventMessage.setFlowId(flowConfig.getId());
        eventMessage.setFlowModel(flowConfig.getModel());
        eventMessage.setRollbackOnFail(flowConfig.getRollbackOnFail());
        eventMessage.setTriggerId(flowTrigger.getId());
        eventMessage.setTriggeredModel(flowTrigger.getTriggeredModel());
        eventMessage.setTriggerRowId(rowId);
        eventMessage.setTriggerParams(params);
        eventMessage.setContext(ContextHolder.getContext());
        return eventMessage;
    }

    private void triggerFlowByChangeLog(List<ChangeLog> changeLogs, boolean isSync) {
        if (CollectionUtils.isEmpty(changeLogs)) {
            return;
        }
        List<FlowEventMessage> flowEventMessages = this.getEventMessagesByChangeLogs(changeLogs, isSync);
        for (FlowEventMessage flowEventMessage : flowEventMessages) {
            this.triggerFlow(flowEventMessage, isSync);
        }
    }

    public Object triggerFlow(FlowEventMessage eventMessage, Boolean isSync) {
        if (Boolean.TRUE.equals(isSync)) {
            if (Boolean.TRUE.equals(eventMessage.getRollbackOnFail())) {
                return this.flowConfigService.executeTransactionalFlow(eventMessage);
            }
            return this.flowConfigService.executeFlow(eventMessage);
        }
        eventMessage.setContext(ContextHolder.getContext());
        this.flowEventProducer.sendFlowEvent(eventMessage);
        return true;
    }

    public Object buttonEvent(TriggerEventVO triggerEventVO) {
        TriggerEventType eventType = TriggerEventType.BUTTON_EVENT;
        String triggerModel = triggerEventVO.getModel();
        String triggerCode = triggerEventVO.getTriggerCode();
        FlowTrigger flowTrigger = FlowManager.getTriggerByCode(triggerModel, triggerCode, eventType);
        Assert.isTrue((Boolean)this.validateTriggerCondition(flowTrigger, triggerEventVO.getEventParams()), (String)"The trigger condition {0} for Button Trigger {1} is not met; the flow will not be triggered!", (Object[])new Object[]{flowTrigger.getTriggerCondition(), triggerCode});
        FlowConfig flowConfig = FlowManager.getFlowById(flowTrigger.getFlowId());
        Assert.notNull((Object)((Object)flowConfig), (String)"Button Trigger {0} is not yet bound to any flow!", (Object[])new Object[]{triggerCode});
        FlowEventMessage eventMessage = this.wrapperFlowEventMessage(flowTrigger, flowConfig, triggerEventVO.getRowId(), triggerEventVO.getEventParams());
        return this.triggerFlow(eventMessage, flowConfig.getSync());
    }

    public Object apiEvent(TriggerEventVO triggerEventVO) {
        TriggerEventType eventType = TriggerEventType.API_EVENT;
        String triggerModel = triggerEventVO.getModel();
        String triggerCode = triggerEventVO.getTriggerCode();
        FlowTrigger flowTrigger = FlowManager.getTriggerByCode(triggerModel, triggerCode, eventType);
        Assert.isTrue((Boolean)this.validateTriggerCondition(flowTrigger, triggerEventVO.getEventParams()), (String)"The trigger condition {0} for API Trigger {1} is not met; the flow will not be triggered!", (Object[])new Object[]{triggerCode, flowTrigger.getTriggerCondition()});
        FlowConfig flowConfig = FlowManager.getFlowById(flowTrigger.getFlowId());
        Assert.notNull((Object)((Object)flowConfig), (String)"API Trigger {0} is not yet bound to any flow!", (Object[])new Object[]{triggerCode});
        FlowEventMessage eventMessage = this.wrapperFlowEventMessage(flowTrigger, flowConfig, triggerEventVO.getRowId(), triggerEventVO.getEventParams());
        return this.triggerFlow(eventMessage, flowConfig.getSync());
    }

    public void cronEvent(CronTaskMessage cronTaskMessage) {
        FlowTrigger flowTrigger = FlowManager.getTriggerByCronId(cronTaskMessage.getCronId());
        if (flowTrigger == null) {
            return;
        }
        Assert.isTrue((Boolean)this.validateTriggerCondition(flowTrigger, null), (String)"The trigger condition {0} for Cron Trigger {1} is not met; the flow will not be triggered!", (Object[])new Object[]{flowTrigger.getName(), flowTrigger.getTriggerCondition()});
        LocalDateTime lastRunTime = cronTaskMessage.getLastExecTime();
        if (lastRunTime == null) {
            lastRunTime = TimeConstant.EPOCH_TIME;
        }
        Map triggerParams = MapUtils.of(CronTaskMessage::getLastExecTime, (Object)lastRunTime);
        FlowConfig flowConfig = FlowManager.getFlowById(flowTrigger.getFlowId());
        Assert.notNull((Object)((Object)flowConfig), (String)"Cron Trigger {0} is not yet bound to any flow!", (Object[])new Object[]{flowTrigger.getName()});
        FlowEventMessage eventMessage = new FlowEventMessage();
        eventMessage.setFlowId(flowConfig.getId());
        eventMessage.setFlowModel(flowConfig.getModel());
        eventMessage.setRollbackOnFail(flowConfig.getRollbackOnFail());
        eventMessage.setTriggerId(flowTrigger.getId());
        eventMessage.setTriggerParams(triggerParams);
        eventMessage.setContext(cronTaskMessage.getContext());
        this.flowEventProducer.sendFlowEvent(eventMessage);
    }

    public Object subflowEvent(String triggerModel, String triggerCode, Map<String, Object> triggerParams) {
        FlowTrigger flowTrigger = FlowManager.getTriggerByCode(triggerModel, triggerCode);
        if (!this.validateTriggerCondition(flowTrigger, triggerParams)) {
            log.debug("The trigger condition {} for Subflow Trigger {}:{} is not met; the flow will not be triggered!", new Object[]{flowTrigger.getTriggerCondition(), triggerModel, triggerCode});
            return null;
        }
        FlowConfig flowConfig = FlowManager.getFlowById(flowTrigger.getFlowId());
        Assert.notNull((Object)((Object)flowConfig), (String)"Subflow Trigger {0}:{1} is not yet bound to any flow!", (Object[])new Object[]{triggerModel, triggerCode});
        FlowEventMessage eventMessage = new FlowEventMessage();
        eventMessage.setFlowId(flowConfig.getId());
        eventMessage.setFlowModel(flowConfig.getModel());
        eventMessage.setRollbackOnFail(flowConfig.getRollbackOnFail());
        eventMessage.setTriggerId(flowTrigger.getId());
        eventMessage.setTriggerParams(triggerParams);
        eventMessage.setContext(ContextHolder.getContext());
        return this.triggerFlow(eventMessage, flowConfig.getSync());
    }

    public Map<String, Object> onchangeEvent(TriggerEventVO triggerEventVO) {
        return Collections.emptyMap();
    }

    private boolean validateTriggerCondition(FlowTrigger flowTrigger, Map<String, Object> triggerParams) {
        if (StringUtils.isNotBlank((CharSequence)flowTrigger.getTriggerCondition())) {
            return ComputeUtils.executeBoolean((String)flowTrigger.getTriggerCondition(), triggerParams);
        }
        return true;
    }
}

