/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.action.processors;

import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.orm.service.ModelService;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.action.ActionProcessor;
import info.openmeta.starter.flow.action.params.CreateDataParams;
import info.openmeta.starter.flow.entity.FlowAction;
import info.openmeta.starter.flow.enums.FlowActionType;
import info.openmeta.starter.flow.utils.FlowUtils;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateDataAction
implements ActionProcessor<CreateDataParams> {
    @Autowired
    private ModelService<? extends Serializable> modelService;

    @Override
    public FlowActionType getActionType() {
        return FlowActionType.CREATE_DATA;
    }

    @Override
    public Class<CreateDataParams> getParamsClass() {
        return CreateDataParams.class;
    }

    @Override
    public void validateParams(FlowAction flowAction, CreateDataParams actionParams) {
        Assert.notBlank((String)actionParams.getModelName(), (String)"The model name parameter for action {0} cannot be empty!", (Object[])new Object[]{flowAction.getName()});
        Assert.notEmpty(actionParams.getRowTemplate(), (String)"The data template parameter for action {0} cannot be empty!", (Object[])new Object[]{flowAction.getName()});
    }

    @Override
    public void execute(FlowAction flowAction, CreateDataParams actionParams, ActionContext actionContext) {
        Map<String, Object> rowMap = FlowUtils.resolveRowTemplate(actionParams.getModelName(), actionParams.getRowTemplate(), actionContext);
        this.modelService.createOne(actionParams.getModelName(), rowMap);
    }
}

