/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.action.processors;

import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.orm.compute.ComputeUtils;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.action.ActionExceptionResolver;
import info.openmeta.starter.flow.action.ActionProcessor;
import info.openmeta.starter.flow.action.params.DecisionGuardParams;
import info.openmeta.starter.flow.entity.FlowAction;
import info.openmeta.starter.flow.enums.ActionExceptionSignal;
import info.openmeta.starter.flow.enums.FlowActionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DecisionGuardAction
implements ActionProcessor<DecisionGuardParams> {
    private static final Logger log = LoggerFactory.getLogger(DecisionGuardAction.class);

    @Override
    public FlowActionType getActionType() {
        return FlowActionType.DECISION_GUARD;
    }

    @Override
    public Class<DecisionGuardParams> getParamsClass() {
        return DecisionGuardParams.class;
    }

    @Override
    public void validateParams(FlowAction flowAction, DecisionGuardParams actionParams) {
        Assert.notBlank((String)actionParams.getPassCondition(), (String)"The pass condition expression for Decision Guard {0} cannot be blank!", (Object[])new Object[]{flowAction.getName()});
        Assert.notNull((Object)((Object)actionParams.getExceptionSignal()), (String)"The exception handling signal for Decision Guard {0} cannot be null!", (Object[])new Object[]{flowAction.getName()});
        if (ActionExceptionSignal.THROW_EXCEPTION.equals((Object)actionParams.getExceptionSignal())) {
            Assert.notBlank((String)actionParams.getExceptionMessage(), (String)"Since Decision Guard {0} is configured to throw an exception, the exception message cannot be empty!", (Object[])new Object[]{flowAction.getName()});
        }
    }

    @Override
    public void execute(FlowAction flowAction, DecisionGuardParams actionParams, ActionContext actionContext) {
        boolean passable = ComputeUtils.executeBoolean((String)actionParams.getPassCondition(), actionContext.getEnv());
        if (!passable) {
            ActionExceptionSignal exceptionSignal = actionParams.getExceptionSignal();
            String exceptionMessage = ComputeUtils.stringInterpolation((String)actionParams.getExceptionMessage(), actionContext.getEnv());
            ActionExceptionResolver.processExceptionSignal(flowAction, exceptionSignal, exceptionMessage, actionContext);
        }
    }
}

