/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.action.processors;

import info.openmeta.framework.base.constant.BaseConstant;
import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.orm.domain.Filters;
import info.openmeta.framework.orm.domain.FlexQuery;
import info.openmeta.framework.orm.service.ModelService;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.action.ActionProcessor;
import info.openmeta.starter.flow.action.enums.ActionGetDataType;
import info.openmeta.starter.flow.action.params.GetDataParams;
import info.openmeta.starter.flow.entity.FlowAction;
import info.openmeta.starter.flow.enums.FlowActionType;
import info.openmeta.starter.flow.utils.FlowUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetDataAction
implements ActionProcessor<GetDataParams> {
    @Autowired
    private ModelService<? extends Serializable> modelService;

    @Override
    public FlowActionType getActionType() {
        return FlowActionType.GET_DATA;
    }

    @Override
    public Class<GetDataParams> getParamsClass() {
        return GetDataParams.class;
    }

    @Override
    public void validateParams(FlowAction flowAction, GetDataParams actionParams) {
        Assert.notBlank((String)actionParams.getModelName(), (String)"The model name parameter for GetDataAction {0} cannot be blank.", (Object[])new Object[]{flowAction.getName()});
        Assert.notNull((Object)((Object)actionParams.getGetDataType()), (String)"The data type parameter for GetDataAction {0} cannot be blank.", (Object[])new Object[]{flowAction.getName()});
        if (ActionGetDataType.ONE_FIELD_VALUE.equals((Object)actionParams.getGetDataType())) {
            Assert.isTrue((Boolean)(actionParams.getFields() != null && actionParams.getFields().size() == 1 ? 1 : 0), (String)"When the GetDataAction {0} is configured to extract a specified field, the fields parameter can only specify one field name.", (Object[])new Object[]{flowAction.getName()});
        }
        if (actionParams.getLimitSize() != null) {
            Assert.isTrue((Boolean)(actionParams.getLimitSize() > 0 && actionParams.getLimitSize() <= BaseConstant.MAX_BATCH_SIZE ? 1 : 0), (String)"When the GetDataAction action {0}  is configured to retrieve multiple rows, the data size parameter must be greater than 0 and less than or equal to the maximum batch limit {1}.", (Object[])new Object[]{flowAction.getName(), BaseConstant.MAX_BATCH_SIZE});
        }
    }

    @Override
    public void execute(FlowAction flowAction, GetDataParams actionParams, ActionContext actionContext) {
        Filters clonedFilters = null;
        if (!Filters.isEmpty((Filters)actionParams.getFilters())) {
            clonedFilters = actionParams.getFilters().deepCopy();
            FlowUtils.resolveFilterValue(actionParams.getModelName(), clonedFilters, actionContext);
        }
        Object result = null;
        if (ActionGetDataType.COUNT_TYPES.contains((Object)actionParams.getGetDataType())) {
            result = this.executeCount(actionParams, clonedFilters);
        } else if (ActionGetDataType.SINGLE_ROW_TYPES.contains((Object)actionParams.getGetDataType())) {
            result = this.executeSingleRow(actionParams, clonedFilters);
        } else if (ActionGetDataType.MULTI_ROW_TYPES.contains((Object)actionParams.getGetDataType())) {
            result = this.executeMultiRows(actionParams, clonedFilters);
        }
        actionContext.put(flowAction.getCode(), result);
    }

    private Object executeCount(GetDataParams actionParams, Filters filters) {
        Long count = this.modelService.count(actionParams.getModelName(), filters);
        if (ActionGetDataType.COUNT.equals((Object)actionParams.getGetDataType())) {
            return count;
        }
        if (ActionGetDataType.EXIST.equals((Object)actionParams.getGetDataType())) {
            return count > 0L;
        }
        return null;
    }

    private Object executeSingleRow(GetDataParams actionParams, Filters filters) {
        FlexQuery flexQuery = new FlexQuery(actionParams.getFields(), filters, actionParams.getOrders());
        flexQuery.setLimitSize(Integer.valueOf(1));
        Map row = this.modelService.searchOne(actionParams.getModelName(), flexQuery);
        if (ActionGetDataType.ONE_FIELD_VALUE.equals((Object)actionParams.getGetDataType())) {
            String fieldName = actionParams.getFields().getFirst();
            return row.get(fieldName);
        }
        return row;
    }

    private Object executeMultiRows(GetDataParams actionParams, Filters filters) {
        FlexQuery flexQuery = new FlexQuery(actionParams.getFields(), filters, actionParams.getOrders());
        if (actionParams.getLimitSize() != null) {
            flexQuery.setLimitSize(actionParams.getLimitSize());
        } else {
            flexQuery.setLimitSize(BaseConstant.MAX_BATCH_SIZE);
        }
        List rows = this.modelService.searchList(actionParams.getModelName(), flexQuery);
        if (!rows.isEmpty() && ActionGetDataType.ONE_FIELD_VALUES.equals((Object)actionParams.getGetDataType())) {
            return rows.stream().map(row -> row.get(actionParams.getFields().getFirst())).collect(Collectors.toSet());
        }
        return rows;
    }
}

