/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.action.processors;

import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.orm.compute.ComputeUtils;
import info.openmeta.starter.ai.entity.AiMessage;
import info.openmeta.starter.ai.service.AiRobotService;
import info.openmeta.starter.ai.vo.ChatMessage;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.action.ActionProcessor;
import info.openmeta.starter.flow.action.params.QueryAiParams;
import info.openmeta.starter.flow.entity.FlowAction;
import info.openmeta.starter.flow.enums.FlowActionType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryAiAction
implements ActionProcessor<QueryAiParams> {
    @Autowired
    private AiRobotService robotService;

    @Override
    public FlowActionType getActionType() {
        return FlowActionType.QUERY_AI;
    }

    @Override
    public Class<QueryAiParams> getParamsClass() {
        return QueryAiParams.class;
    }

    @Override
    public void validateParams(FlowAction flowAction, QueryAiParams actionParams) {
        Assert.notBlank((String)actionParams.getQueryContent(), (String)"The query parameter for Query AI Action {0} cannot be empty.", (Object[])new Object[]{flowAction.getName()});
    }

    @Override
    public void execute(FlowAction flowAction, QueryAiParams actionParams, ActionContext actionContext) {
        String query = ComputeUtils.stringInterpolation((String)actionParams.getQueryContent(), actionContext.getEnv());
        ChatMessage chatMessage = new ChatMessage(actionParams.getRobotId(), actionParams.getConversationId(), query);
        AiMessage aiMessage = this.robotService.chat(chatMessage);
        actionContext.put(flowAction.getCode(), aiMessage.getAnswer());
    }
}

