/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.action.processors;

import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.base.utils.StringTools;
import info.openmeta.framework.orm.domain.Filters;
import info.openmeta.framework.orm.service.ModelService;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.action.ActionProcessor;
import info.openmeta.starter.flow.action.params.UpdateDataParams;
import info.openmeta.starter.flow.entity.FlowAction;
import info.openmeta.starter.flow.enums.FlowActionType;
import info.openmeta.starter.flow.utils.FlowUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UpdateDataAction
implements ActionProcessor<UpdateDataParams> {
    @Autowired
    private ModelService<? extends Serializable> modelService;

    @Override
    public FlowActionType getActionType() {
        return FlowActionType.UPDATE_DATA;
    }

    @Override
    public Class<UpdateDataParams> getParamsClass() {
        return UpdateDataParams.class;
    }

    @Override
    public void validateParams(FlowAction flowAction, UpdateDataParams actionParams) {
        Assert.notEmpty(actionParams.getRowTemplate(), (String)"The model name parameter for Update Action {0} cannot be blank!", (Object[])new Object[]{flowAction.getName()});
        Assert.notTrue((Boolean)(StringUtils.isBlank((CharSequence)actionParams.getPkVariable()) && Filters.isEmpty((Filters)actionParams.getFilters()) ? 1 : 0), (String)"The parameter configuration for UpdateDataAction {0} must specify at least\nthe primary key parameter or the update data filtering conditions.\n", (Object[])new Object[]{flowAction.getName()});
    }

    @Override
    public void execute(FlowAction flowAction, UpdateDataParams actionParams, ActionContext actionContext) {
        String pkVariable = actionParams.getPkVariable();
        Filters updateFilters = null;
        if (StringTools.isVariable((String)pkVariable)) {
            Collection<?> ids = FlowUtils.getIdsFromPkVariable(flowAction, pkVariable, actionContext);
            if (CollectionUtils.isEmpty(ids)) {
                return;
            }
            updateFilters = Filters.in((String)"id", ids);
        }
        if (!Filters.isEmpty((Filters)actionParams.getFilters())) {
            Filters clonedFilters = actionParams.getFilters().deepCopy();
            FlowUtils.resolveFilterValue(actionParams.getModelName(), clonedFilters, actionContext);
            updateFilters = Filters.merge((Filters[])new Filters[]{updateFilters, clonedFilters});
        }
        if (Filters.isEmpty(updateFilters)) {
            return;
        }
        Map<String, Object> rowMap = FlowUtils.resolveRowTemplate(actionParams.getModelName(), actionParams.getRowTemplate(), actionContext);
        this.modelService.updateByFilter(actionParams.getModelName(), updateFilters, rowMap);
    }
}

