/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.action.processors;

import info.openmeta.framework.base.exception.BusinessException;
import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.orm.compute.ComputeUtils;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.action.ActionProcessor;
import info.openmeta.starter.flow.action.params.ValidateDataParams;
import info.openmeta.starter.flow.entity.FlowAction;
import info.openmeta.starter.flow.enums.FlowActionType;
import org.springframework.stereotype.Component;

@Component
public class ValidateDataAction
implements ActionProcessor<ValidateDataParams> {
    @Override
    public FlowActionType getActionType() {
        return FlowActionType.VALIDATE_DATA;
    }

    @Override
    public Class<ValidateDataParams> getParamsClass() {
        return ValidateDataParams.class;
    }

    @Override
    public void validateParams(FlowAction flowAction, ValidateDataParams actionParams) {
        Assert.notBlank((String)actionParams.getExpression(), (String)"The calculation formula for ValidateDataAction {0} cannot be empty!", (Object[])new Object[]{flowAction.getName()});
        Assert.notBlank((String)actionParams.getExceptionMsg(), (String)"The exception message for ValidateDataAction {0} cannot be empty!", (Object[])new Object[]{flowAction.getName()});
    }

    @Override
    public void execute(FlowAction flowAction, ValidateDataParams actionParams, ActionContext actionContext) {
        boolean isTrue = ComputeUtils.executeBoolean((String)actionParams.getExpression(), actionContext.getEnv());
        if (!isTrue) {
            String exceptionMessage = ComputeUtils.stringInterpolation((String)actionParams.getExceptionMsg(), actionContext.getEnv());
            throw new BusinessException(exceptionMessage, new Object[0]);
        }
    }
}

