/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.controller;

import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.orm.annotation.DataMask;
import info.openmeta.framework.web.response.ApiResponse;
import info.openmeta.starter.flow.FlowAutomation;
import info.openmeta.starter.flow.message.dto.FlowEventMessage;
import info.openmeta.starter.flow.vo.TriggerEventVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Flow Automation")
@RestController
@RequestMapping(value={"/automation"})
public class AutomationController {
    @Autowired
    private Environment env;
    @Autowired
    private FlowAutomation automation;

    @Operation(summary="Button Event", description="Trigger the flow by button event. ")
    @PostMapping(value={"/buttonEvent"})
    public ApiResponse<Object> buttonEvent(@RequestBody @Valid TriggerEventVO triggerEventVO) {
        return ApiResponse.success((Object)this.automation.buttonEvent(triggerEventVO));
    }

    @Operation(summary="API Event", description="Trigger the flow by API event. ")
    @PostMapping(value={"/apiEvent"})
    @DataMask
    public ApiResponse<Object> apiEvent(@RequestBody @Valid TriggerEventVO triggerEventVO) {
        return ApiResponse.success((Object)this.automation.apiEvent(triggerEventVO));
    }

    @Operation(summary="Onchange Event", description="Pass the current data and return a Map of field value changes that affect other fields.")
    @PostMapping(value={"/onchange"})
    @DataMask
    public ApiResponse<Map<String, Object>> onchange(@RequestBody @Valid TriggerEventVO triggerEventVO) {
        return ApiResponse.success(this.automation.onchangeEvent(triggerEventVO));
    }

    @Operation(summary="Simulate Event Message", description="Simulate flow triggering by passing a FlowEventMessage, suitable for scenarios such as ChangeLog, Cron, etc.\nFor non-production environment testing only.")
    @PostMapping(value={"/simulateEvent"})
    public ApiResponse<Object> buttonEvent(@RequestBody FlowEventMessage flowEventMessage) {
        String[] profiles = this.env.getActiveProfiles();
        Assert.notTrue((Boolean)Arrays.asList(profiles).contains("prod"), (String)"This API is only open to non-production environments!", (Object[])new Object[0]);
        return ApiResponse.success((Object)this.automation.triggerFlow(flowEventMessage, true));
    }
}

