/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.message;

import info.openmeta.framework.base.enums.SystemUser;
import info.openmeta.framework.orm.annotation.SwitchUser;
import info.openmeta.framework.orm.entity.BaseModel;
import info.openmeta.starter.cron.entity.SysCronLog;
import info.openmeta.starter.cron.message.dto.CronTaskMessage;
import info.openmeta.starter.cron.service.SysCronLogService;
import info.openmeta.starter.flow.FlowAutomation;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="${rocketmq.topics.cron-task.topic}", consumerGroup="${rocketmq.topics.cron-task.flow-group}")
public class CronTaskFlowConsumer
implements RocketMQListener<CronTaskMessage> {
    @Autowired
    private FlowAutomation flowAutomation;
    @Autowired
    private SysCronLogService cronLogService;

    @SwitchUser(value=SystemUser.CRON_USER)
    public void onMessage(CronTaskMessage cronTaskMessage) {
        this.persistCronLog(cronTaskMessage);
        this.flowAutomation.cronEvent(cronTaskMessage);
    }

    private void persistCronLog(CronTaskMessage cronTaskMessage) {
        SysCronLog cronLog = new SysCronLog();
        cronLog.setCronId(cronTaskMessage.getCronId());
        cronLog.setCronName(cronTaskMessage.getCronName());
        cronLog.setStartTime(cronTaskMessage.getTriggerTime());
        this.cronLogService.createOne((BaseModel)cronLog);
    }
}

