/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.message;

import info.openmeta.framework.base.context.Context;
import info.openmeta.framework.base.context.ContextHolder;
import info.openmeta.starter.flow.message.dto.FlowEventMessage;
import info.openmeta.starter.flow.service.FlowConfigService;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(topic="${rocketmq.topics.flow-event.topic}", consumerGroup="${rocketmq.topics.flow-event.group}")
public class FlowEventConsumer
implements RocketMQListener<FlowEventMessage> {
    @Autowired
    private FlowConfigService flowConfigService;
    @Value(value="${enable.flow:true}")
    private Boolean enableFlow;

    public void onMessage(FlowEventMessage eventMessage) {
        if (!this.enableFlow.booleanValue()) {
            return;
        }
        ContextHolder.setContext((Context)eventMessage.getContext());
        if (Boolean.TRUE.equals(eventMessage.getRollbackOnFail())) {
            this.flowConfigService.executeTransactionalFlow(eventMessage);
        } else {
            this.flowConfigService.executeFlow(eventMessage);
        }
    }
}

