/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.message;

import info.openmeta.starter.flow.message.dto.FlowEventMessage;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FlowEventProducer {
    private static final Logger log = LoggerFactory.getLogger(FlowEventProducer.class);
    @Value(value="${rocketmq.topics.flow-event.topic}")
    private String flowEventTopic;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;

    public void sendFlowEvent(FlowEventMessage message) {
        this.rocketMQTemplate.asyncSend(this.flowEventTopic, (Object)message, new SendCallback(this){

            public void onSuccess(SendResult sendResult) {
            }

            public void onException(Throwable throwable) {
                log.error("Failed to send flow event to MQ!", throwable);
            }
        });
    }
}

