/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.service.impl;

import info.openmeta.framework.orm.compute.ComputeUtils;
import info.openmeta.framework.orm.service.impl.EntityServiceImpl;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.action.ActionFactory;
import info.openmeta.starter.flow.entity.FlowAction;
import info.openmeta.starter.flow.service.FlowActionService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowActionServiceImpl
extends EntityServiceImpl<FlowAction, Long>
implements FlowActionService {
    @Autowired
    private ActionFactory<?> actionFactory;

    private boolean isValidActionCondition(String condition, ActionContext actionContext) {
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            return ComputeUtils.executeBoolean((String)condition, actionContext.getEnv());
        }
        return true;
    }

    @Override
    public void processFlowAction(FlowAction flowAction, ActionContext actionContext) {
        if (!this.isValidActionCondition(flowAction.getActionCondition(), actionContext)) {
            actionContext.put(flowAction.getCode(), null);
            return;
        }
        this.actionFactory.executeActionProcessor(flowAction, actionContext);
    }
}

