/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.service.impl;

import info.openmeta.framework.orm.domain.Filters;
import info.openmeta.framework.orm.domain.FlexQuery;
import info.openmeta.framework.orm.domain.Orders;
import info.openmeta.framework.orm.service.impl.EntityServiceImpl;
import info.openmeta.starter.flow.FlowEnv;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.entity.FlowConfig;
import info.openmeta.starter.flow.entity.FlowEvent;
import info.openmeta.starter.flow.entity.FlowInstance;
import info.openmeta.starter.flow.entity.FlowNode;
import info.openmeta.starter.flow.enums.ActionExceptionSignal;
import info.openmeta.starter.flow.enums.FlowStatus;
import info.openmeta.starter.flow.enums.FlowType;
import info.openmeta.starter.flow.message.dto.FlowEventMessage;
import info.openmeta.starter.flow.service.FlowConfigService;
import info.openmeta.starter.flow.service.FlowEventService;
import info.openmeta.starter.flow.service.FlowInstanceService;
import info.openmeta.starter.flow.service.FlowNodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;

@Service
public class FlowConfigServiceImpl
extends EntityServiceImpl<FlowConfig, Long>
implements FlowConfigService {
    private static final Logger log = LoggerFactory.getLogger(FlowConfigServiceImpl.class);
    @Autowired
    private FlowInstanceService flowInstanceService;
    @Autowired
    private FlowNodeService flowNodeService;
    @Autowired
    private FlowEventService flowEventService;

    private FlowConfig getFlowDefinition(Long flowId) {
        FlowConfig flowConfig = (FlowConfig)this.readOne(flowId);
        Filters filters = Filters.eq(FlowNode::getFlowId, (Object)flowId);
        Orders orders = Orders.ofAsc(FlowNode::getSequence);
        flowConfig.setNodeList(this.flowNodeService.searchList(new FlexQuery(filters, orders)));
        return flowConfig;
    }

    @Override
    public Object executeFlow(FlowEventMessage eventMessage) {
        FlowConfig flowDefinition = this.getFlowDefinition(eventMessage.getFlowId());
        StopWatch stopWatch = new StopWatch("Executing flow\uff1a" + flowDefinition.getName());
        ActionContext actionContext = new ActionContext(FlowEnv.getEnv());
        actionContext.put("TriggerRowId", eventMessage.getTriggerRowId());
        actionContext.put("TriggerParams", eventMessage.getTriggerParams());
        for (FlowNode flowNode : flowDefinition.getNodeList()) {
            stopWatch.start(flowNode.getNodeType().getType() + " - " + flowNode.getName());
            this.flowNodeService.processFlowNode(flowNode, actionContext);
            stopWatch.stop();
            if (!ActionExceptionSignal.END_FLOW.equals((Object)actionContext.getExceptionSignal())) continue;
            log.info(stopWatch.prettyPrint());
            return null;
        }
        log.warn(stopWatch.prettyPrint());
        return actionContext.getReturnData();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Object executeTransactionalFlow(FlowEventMessage eventMessage) {
        return this.executeFlow(eventMessage);
    }

    private void prepareFlowData(FlowConfig flowDefinition, FlowEventMessage eventMessage) {
        if (FlowType.VALIDATION_FLOW.equals((Object)flowDefinition.getFlowType())) {
            return;
        }
        FlowEvent flowEvent = this.createFlowEvent(eventMessage);
        FlowInstance flowInstance = this.initFlowInstance(flowEvent);
    }

    private FlowEvent createFlowEvent(FlowEventMessage eventMessage) {
        FlowEvent flowEvent = new FlowEvent();
        flowEvent.setFlowId(eventMessage.getFlowId());
        flowEvent.setFlowNodeId(eventMessage.getFlowNodeId());
        flowEvent.setFlowModel(eventMessage.getFlowModel());
        String rowId = eventMessage.getTriggerRowId() == null ? null : eventMessage.getTriggerRowId().toString();
        flowEvent.setRowId(rowId);
        flowEvent.setTriggerId(eventMessage.getTriggerId());
        flowEvent.setTriggeredModel(eventMessage.getTriggeredModel());
        return (FlowEvent)this.flowEventService.createOneAndReturn(flowEvent);
    }

    private FlowInstance initFlowInstance(FlowEvent flowEvent) {
        FlowInstance flowInstance = new FlowInstance();
        flowInstance.setModel(flowEvent.getFlowModel());
        flowInstance.setRowId(flowEvent.getRowId());
        flowInstance.setFlowId(flowEvent.getFlowId());
        flowInstance.setTriggerId(flowEvent.getTriggerId());
        flowInstance.setCurrentStatus(FlowStatus.INITIAL);
        return (FlowInstance)this.flowInstanceService.createOneAndReturn(flowInstance);
    }
}

