/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import info.openmeta.framework.base.constant.BaseConstant;
import info.openmeta.framework.base.exception.IllegalArgumentException;
import info.openmeta.framework.base.exception.JSONException;
import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.base.utils.JsonMapper;
import info.openmeta.framework.base.utils.StringTools;
import info.openmeta.framework.orm.compute.ComputeUtils;
import info.openmeta.framework.orm.domain.Filters;
import info.openmeta.framework.orm.domain.FlexQuery;
import info.openmeta.framework.orm.domain.Page;
import info.openmeta.framework.orm.service.impl.EntityServiceImpl;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.entity.FlowAction;
import info.openmeta.starter.flow.entity.FlowNode;
import info.openmeta.starter.flow.enums.ActionExceptionSignal;
import info.openmeta.starter.flow.enums.FlowNodeType;
import info.openmeta.starter.flow.node.LoopByDatasetParams;
import info.openmeta.starter.flow.node.LoopByPageParams;
import info.openmeta.starter.flow.service.FlowActionService;
import info.openmeta.starter.flow.service.FlowNodeService;
import info.openmeta.starter.flow.utils.FlowUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

@Service
public class FlowNodeServiceImpl
extends EntityServiceImpl<FlowNode, Long>
implements FlowNodeService {
    private static final Logger log = LoggerFactory.getLogger(FlowNodeServiceImpl.class);
    @Autowired
    private FlowActionService flowActionService;

    private boolean isValidNodeCondition(String condition, ActionContext actionContext) {
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            return ComputeUtils.executeBoolean((String)condition, actionContext.getEnv());
        }
        return true;
    }

    private LoopByDatasetParams extractLoopByDatasetParams(FlowNode flowNode) {
        LoopByDatasetParams loopByDatasetParams;
        try {
            loopByDatasetParams = (LoopByDatasetParams)JsonMapper.jsonNodeToObject((JsonNode)flowNode.getLoopParams(), LoopByDatasetParams.class);
        }
        catch (JSONException e) {
            throw new JSONException("Failed to parse the loop parameters of the `LoopByDataset` node {0}: {1}", new Object[]{flowNode.getName(), e.getMessage()});
        }
        Assert.notNull((Object)loopByDatasetParams, (String)"Loop parameters are not defined for the `LoopByDataset` node {0}!", (Object[])new Object[]{flowNode.getName()});
        Assert.notBlank((String)loopByDatasetParams.getDataSetParam(), (String)"The `LoopByDataset` node {0} must specify a dataset variable!", (Object[])new Object[]{flowNode.getName()});
        Assert.isTrue((Boolean)StringTools.isVariable((String)loopByDatasetParams.getDataSetParam()), (String)"The dataset variable {0} of the `LoopByDataset` node {1} must be identified with `#{}`!", (Object[])new Object[]{loopByDatasetParams.getDataSetParam(), flowNode.getName()});
        Assert.notBlank((String)loopByDatasetParams.getLoopItemNaming(), (String)"The loop parameter name of the `LoopByDataset` node {0} cannot be empty!", (Object[])new Object[]{loopByDatasetParams.getLoopItemNaming()});
        return loopByDatasetParams;
    }

    private LoopByPageParams extractLoopByPageParams(FlowNode flowNode) {
        LoopByPageParams loopByPageParams;
        try {
            loopByPageParams = (LoopByPageParams)JsonMapper.jsonNodeToObject((JsonNode)flowNode.getLoopParams(), LoopByPageParams.class);
        }
        catch (JSONException e) {
            throw new JSONException("Failed to parse the pagination parameters of the `LoopByPage` node {0}: {1}", new Object[]{flowNode.getName(), e.getMessage()});
        }
        Assert.notNull((Object)loopByPageParams, (String)"Pagination parameters are not defined for the `LoopByPage` node {0}!", (Object[])new Object[]{flowNode.getName()});
        Assert.notBlank((String)loopByPageParams.getModel(), (String)"The model name parameter of the `LoopByPage` node {0} cannot be empty!", (Object[])new Object[]{flowNode.getName()});
        Assert.notEmpty(loopByPageParams.getFields(), (String)"The field names parameter of the `LoopByPage` node {0} cannot be empty!", (Object[])new Object[]{flowNode.getName()});
        Assert.notBlank((String)loopByPageParams.getPageParamNaming(), (String)"The loop parameter naming of the `LoopByPage` node {0} cannot be blank!", (Object[])new Object[]{flowNode.getName()});
        if (loopByPageParams.getPageSize() == null || loopByPageParams.getPageSize() < 1) {
            loopByPageParams.setPageSize(BaseConstant.DEFAULT_PAGE_SIZE);
        } else {
            Assert.isTrue((Boolean)(loopByPageParams.getPageSize() <= BaseConstant.MAX_BATCH_SIZE ? 1 : 0), (String)"The page size {0} of the `LoopByPage` node {1} cannot exceed the maximum limit: {2}", (Object[])new Object[]{loopByPageParams.getPageSize(), flowNode.getName(), BaseConstant.MAX_BATCH_SIZE});
        }
        return loopByPageParams;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void processFlowNode(FlowNode flowNode, ActionContext actionContext) {
        if (!this.isValidNodeCondition(flowNode.getNodeCondition(), actionContext)) {
            return;
        }
        if (CollectionUtils.isEmpty(flowNode.getActionList())) {
            return;
        }
        if (FlowNodeType.LOOP_BY_DATASET.equals((Object)flowNode.getNodeType())) {
            this.executeLoopByDataset(flowNode, actionContext);
        } else if (FlowNodeType.LOOP_BY_PAGE.equals((Object)flowNode.getNodeType())) {
            this.executeLoopByPage(flowNode, actionContext);
        } else {
            this.executeNodeActions(flowNode, actionContext);
        }
    }

    private void executeLoopByDataset(FlowNode flowNode, ActionContext actionContext) {
        LoopByDatasetParams loopByDatasetParams = this.extractLoopByDatasetParams(flowNode);
        Object dataSet = StringTools.extractVariable((String)loopByDatasetParams.getDataSetParam(), actionContext.getEnv());
        if (dataSet instanceof Collection) {
            ArrayList<Object> returnList = new ArrayList<Object>();
            for (Object item : (Collection)dataSet) {
                ActionContext innerActionContext = actionContext.copy();
                innerActionContext.setInLoop(true);
                innerActionContext.put(loopByDatasetParams.getLoopItemNaming(), item);
                this.executeNodeActions(flowNode, innerActionContext);
                if (ActionExceptionSignal.END_LOOP_NODE.equals((Object)innerActionContext.getExceptionSignal()) || ActionExceptionSignal.END_FLOW.equals((Object)innerActionContext.getExceptionSignal())) {
                    return;
                }
                if (innerActionContext.getReturnData() == null) continue;
                returnList.add(innerActionContext.getReturnData());
            }
            if (!returnList.isEmpty()) {
                actionContext.setReturnData(returnList);
            }
        } else {
            throw new IllegalArgumentException("In the `LoopByDataset` node {0}, the value of dataset parameter {0} must be a collection object! {2}", new Object[]{flowNode.getName(), loopByDatasetParams.getDataSetParam(), dataSet});
        }
    }

    private void executeLoopByPage(FlowNode flowNode, ActionContext actionContext) {
        Long total;
        LoopByPageParams loopByPageParams = this.extractLoopByPageParams(flowNode);
        Filters clonedFilters = null;
        if (!Filters.isEmpty((Filters)loopByPageParams.getFilters())) {
            clonedFilters = loopByPageParams.getFilters().deepCopy();
            FlowUtils.resolveFilterValue(loopByPageParams.getModel(), clonedFilters, actionContext);
        }
        if ((total = this.modelService.count(loopByPageParams.getModel(), clonedFilters)) == 0L) {
            return;
        }
        Page page = Page.of((Integer)BaseConstant.DEFAULT_PAGE_NUMBER, (Integer)loopByPageParams.getPageSize(), (boolean)false);
        page.setTotal(total.longValue());
        FlexQuery flexQuery = new FlexQuery(loopByPageParams.getFields(), clonedFilters, loopByPageParams.getOrders());
        ArrayList<Object> returnList = new ArrayList<Object>();
        while (!(page = this.modelService.searchPage(loopByPageParams.getModel(), flexQuery, page)).getRows().isEmpty()) {
            ActionContext innerActionContext = actionContext.copy();
            innerActionContext.setInLoop(true);
            innerActionContext.put(loopByPageParams.getPageParamNaming(), page.getRows());
            this.executeNodeActions(flowNode, innerActionContext);
            if (ActionExceptionSignal.END_LOOP_NODE.equals((Object)innerActionContext.getExceptionSignal()) || ActionExceptionSignal.END_FLOW.equals((Object)innerActionContext.getExceptionSignal())) {
                return;
            }
            if (innerActionContext.getReturnData() != null) {
                returnList.add(innerActionContext.getReturnData());
            }
            if (page.toNext()) continue;
        }
        if (!returnList.isEmpty()) {
            actionContext.setReturnData(returnList);
        }
    }

    private void executeNodeActions(FlowNode flowNode, ActionContext actionContext) {
        StopWatch stopWatch = new StopWatch("Executing the node " + flowNode.getName());
        for (FlowAction flowAction : flowNode.getActionList()) {
            stopWatch.start(flowAction.getActionType().getName() + " - " + flowAction.getName());
            this.flowActionService.processFlowAction(flowAction, actionContext);
            stopWatch.stop();
            if (actionContext.getExceptionSignal() == null) continue;
            log.info(stopWatch.prettyPrint());
            return;
        }
        log.info(stopWatch.prettyPrint());
    }
}

