/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.flow.utils;

import info.openmeta.framework.base.exception.IllegalArgumentException;
import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.base.utils.StringTools;
import info.openmeta.framework.orm.compute.ComputeUtils;
import info.openmeta.framework.orm.domain.FilterUnit;
import info.openmeta.framework.orm.domain.Filters;
import info.openmeta.framework.orm.enums.FieldType;
import info.openmeta.framework.orm.enums.FilterType;
import info.openmeta.framework.orm.meta.MetaField;
import info.openmeta.framework.orm.meta.ModelManager;
import info.openmeta.starter.flow.action.ActionContext;
import info.openmeta.starter.flow.entity.FlowAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowUtils {
    private static final Logger log = LoggerFactory.getLogger(FlowUtils.class);

    public static Collection<?> getIdsFromPkVariable(FlowAction flowAction, String pkVariable, ActionContext actionContext) {
        String variableName = pkVariable.substring(2, pkVariable.length() - 1);
        Assert.isTrue((Boolean)actionContext.containsKey(variableName), (String)"In flow action {0}, the primary key parameter {1} does not exist in the actionContext.", (Object[])new Object[]{flowAction.getName(), variableName});
        Object pks = actionContext.get(variableName);
        if (pks == null) {
            return Collections.emptyList();
        }
        if (pks instanceof Collection) {
            return (Collection)pks;
        }
        return Collections.singleton(pks);
    }

    public static Map<String, Object> resolveDataTemplate(Map<String, Object> dataTemplate, ActionContext actionContext) {
        return FlowUtils.resolveRowTemplate(null, dataTemplate, actionContext);
    }

    public static Map<String, Object> resolveRowTemplate(@Nullable String modelName, Map<String, Object> rowTemplate, ActionContext actionContext) {
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        rowTemplate.forEach((field, value) -> {
            if (value instanceof String && StringTools.isVariable((String)((String)value))) {
                Object fieldValue = StringTools.extractVariable((String)((String)value), actionContext.getEnv());
                rowMap.put((String)field, fieldValue);
            } else if (value instanceof String && StringTools.isExpression((String)((String)value))) {
                Object result = FlowUtils.executeExpression(modelName, field, (String)value, actionContext);
                rowMap.put((String)field, result);
            } else {
                rowMap.put((String)field, value);
            }
        });
        return rowMap;
    }

    public static Object executeExpression(@Nullable String modelName, String field, String expressionLabel, ActionContext actionContext) {
        String expression = expressionLabel.substring(2, expressionLabel.length() - 1);
        List dependentVariables = ComputeUtils.compile((String)expression).getVariableFullNames();
        dependentVariables.removeAll(actionContext.keySet());
        Assert.isTrue((Boolean)dependentVariables.isEmpty(), (String)"The variables {1} appear in the calculated expression for the data template parameter field {0},\ndo not exist in the action context.", (Object[])new Object[]{dependentVariables});
        if (StringUtils.isBlank((CharSequence)modelName)) {
            return ComputeUtils.execute((String)expression, actionContext.getEnv());
        }
        MetaField metaField = ModelManager.getModelField((String)modelName, (String)field);
        return ComputeUtils.execute((String)expression, actionContext.getEnv(), (Integer)metaField.getScale(), (FieldType)metaField.getFieldType());
    }

    public static void resolveFilterValue(String modelName, Filters filters, ActionContext actionContext) {
        if (Filters.isEmpty((Filters)filters)) {
            return;
        }
        if (FilterType.LEAF.equals((Object)filters.getType()) && filters.getFilterUnit() != null && filters.getFilterUnit().getValue() instanceof String) {
            FilterUnit filterUnit = filters.getFilterUnit();
            String paramValue = (String)filterUnit.getValue();
            if (StringTools.isVariable((String)paramValue)) {
                Object value = StringTools.extractVariable((String)paramValue, actionContext.getEnv());
                filterUnit.setValue(value);
                FlowUtils.validateFilterUnitValue(filterUnit, paramValue);
            } else if (StringTools.isExpression((String)paramValue)) {
                MetaField lastField = ModelManager.getLastFieldOfCascaded((String)modelName, (String)filterUnit.getField());
                Object value = FlowUtils.executeExpression(modelName, lastField.getFieldName(), paramValue, actionContext);
                filterUnit.setValue(value);
                FlowUtils.validateFilterUnitValue(filterUnit, paramValue);
            }
        } else if (FilterType.TREE.equals((Object)filters.getType()) && filters.getChildren() != null) {
            List children = filters.getChildren();
            children.forEach(child -> FlowUtils.resolveFilterValue(modelName, child, actionContext));
        }
    }

    private static void validateFilterUnitValue(FilterUnit filterUnit, String paramValue) {
        try {
            FilterUnit.validateFilterUnit((FilterUnit)filterUnit);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Validation failed for the parameter {0} of filter condition {1}: {2}", new Object[]{paramValue, filterUnit.toString(), e.getMessage()});
        }
    }
}

