/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.metadata.controller;

import info.openmeta.framework.base.enums.SystemUser;
import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.orm.annotation.SwitchUser;
import info.openmeta.framework.web.dto.MetadataUpgradePackage;
import info.openmeta.framework.web.response.ApiResponse;
import info.openmeta.starter.metadata.service.MetadataService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Metadata Upgrade API")
@RestController
@RequestMapping(value={"/metadata"})
public class MetadataController {
    @Autowired
    private MetadataService metadataService;

    @Operation(summary="upgrade")
    @PostMapping(value={"/upgrade"})
    @SwitchUser(value=SystemUser.INTEGRATION_USER)
    public ApiResponse<Boolean> upgradePackage(@RequestBody List<MetadataUpgradePackage> metadataPackages) {
        Assert.notEmpty(metadataPackages, (String)"Metadata upgrade data must not be empty!", (Object[])new Object[0]);
        this.metadataService.upgradeMetadata(metadataPackages);
        this.metadataService.reloadMetadata();
        return ApiResponse.success((Object)true);
    }

    @Operation(summary="reload")
    @PostMapping(value={"/reload"})
    public ApiResponse<Boolean> reloadModelManager() {
        this.metadataService.reloadMetadata();
        return ApiResponse.success((Object)true);
    }
}

