/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.metadata.controller;

import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.orm.meta.MetaOptionItem;
import info.openmeta.framework.orm.meta.OptionManager;
import info.openmeta.framework.web.controller.EntityController;
import info.openmeta.framework.web.response.ApiResponse;
import info.openmeta.starter.metadata.entity.SysOptionSet;
import info.openmeta.starter.metadata.service.SysOptionSetService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="SysOptionSet")
@RestController
@RequestMapping(value={"/SysOptionSet"})
public class SysOptionSetController
extends EntityController<SysOptionSetService, SysOptionSet, Long> {
    @GetMapping(value={"/getOptionSetItems"})
    @Operation(summary="getOptionSetItems", description="Get the option set items of the specified option set code.")
    @Parameter(name="optionSetCode", description="Option set code", required=true)
    public ApiResponse<List<MetaOptionItem>> getOptionSetItems(String optionSetCode) {
        Assert.notBlank((String)optionSetCode, (String)"Option set code cannot be empty.", (Object[])new Object[0]);
        return ApiResponse.success((Object)OptionManager.getMetaOptionItems((String)optionSetCode));
    }
}

