/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.metadata.controller;

import info.openmeta.framework.base.enums.SystemUser;
import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.orm.annotation.SwitchUser;
import info.openmeta.framework.web.controller.EntityController;
import info.openmeta.framework.web.response.ApiResponse;
import info.openmeta.starter.metadata.entity.SysPreData;
import info.openmeta.starter.metadata.service.SysPreDataService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="SysPreData")
@RestController
@RequestMapping(value={"/SysPreData"})
public class SysPreDataController
extends EntityController<SysPreDataService, SysPreData, Long> {
    @Operation(summary="loadData", description="Load the specified list of predefined data files from the root directory resources/data,\nsupporting data files in JSON, XML, and CSV formats.\n")
    @PostMapping(value={"/loadData"})
    public ApiResponse<Boolean> loadPredefinedData(@RequestBody List<String> fileNames) {
        Assert.allNotBlank(fileNames, (String)"The filename of the data to be loaded cannot be empty!", (Object[])new Object[0]);
        ((SysPreDataService)this.service).loadPredefinedData(fileNames);
        return ApiResponse.success((Object)true);
    }

    @Operation(summary="uploadFile")
    @PostMapping(value={"/uploadFile"})
    @SwitchUser(value=SystemUser.INTEGRATION_USER)
    public ApiResponse<Boolean> uploadPredefinedData(@RequestParam(value="file") MultipartFile file) {
        Assert.notTrue((Boolean)file.isEmpty(), (String)"The file to be uploaded cannot be empty!", (Object[])new Object[0]);
        ((SysPreDataService)this.service).loadPredefinedData(file);
        return ApiResponse.success((Object)true);
    }
}

