/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.metadata.controller;

import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.orm.annotation.SkipPermissionCheck;
import info.openmeta.framework.web.controller.EntityController;
import info.openmeta.framework.web.response.ApiResponse;
import info.openmeta.starter.metadata.controller.vo.ModelViewVO;
import info.openmeta.starter.metadata.entity.SysView;
import info.openmeta.starter.metadata.service.SysViewService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="SysView")
@RestController
@RequestMapping(value={"/SysView"})
public class SysViewController
extends EntityController<SysViewService, SysView, Long> {
    @Operation(summary="setDefaultView", description="Set the current user's default view based on the model name and view ID: {\"modelName\": \"Employee\", \"viewId\": 1}")
    @PostMapping(value={"/setDefaultView"})
    @SkipPermissionCheck
    public ApiResponse<Boolean> setDefaultView(@RequestBody @Valid ModelViewVO modelViewVO) {
        return ApiResponse.success((Object)((SysViewService)this.service).setDefaultView(modelViewVO.getModel(), modelViewVO.getViewId()));
    }

    @Operation(summary="getModelViews", description="Get the list of views visible to the current user based on the model name. [Public views, personal views] and sorted by sequence.")
    @GetMapping(value={"/getModelViews"}, params={"modelName"})
    @Parameters(value={@Parameter(name="modelName", description="Model Name", required=true)})
    public ApiResponse<List<SysView>> getModelViews(@RequestParam String modelName) {
        Assert.notBlank((String)modelName, (String)"Model name cannot be empty\uff01", (Object[])new Object[0]);
        return ApiResponse.success(((SysViewService)this.service).getModelViews(modelName));
    }
}

