/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.metadata.message;

import info.openmeta.framework.base.context.Context;
import info.openmeta.framework.base.context.ContextHolder;
import info.openmeta.framework.orm.meta.AppStartup;
import info.openmeta.starter.metadata.message.dto.InnerBroadcastMessage;
import info.openmeta.starter.metadata.message.enums.InnerBroadcastType;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RocketMQMessageListener(messageModel=MessageModel.BROADCASTING, topic="${rocketmq.topics.inner-broadcast.topic}", consumerGroup="${rocketmq.topics.inner-broadcast.group}")
public class InnerBroadcastConsumer
implements RocketMQListener<InnerBroadcastMessage> {
    private static final Logger log = LoggerFactory.getLogger(InnerBroadcastConsumer.class);
    @Autowired
    private AppStartup appStartup;

    public void onMessage(InnerBroadcastMessage message) {
        ContextHolder.setContext((Context)message.getContext());
        if (InnerBroadcastType.RELOAD_METADATA.equals((Object)message.getBroadcastType())) {
            this.appStartup.afterPropertiesSet();
        } else {
            log.warn("Unknown broadcast type: {}", (Object)message.getBroadcastType());
        }
    }
}

