/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.metadata.message;

import info.openmeta.starter.metadata.message.dto.InnerBroadcastMessage;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class InnerBroadcastProducer {
    private static final Logger log = LoggerFactory.getLogger(InnerBroadcastProducer.class);
    @Value(value="${rocketmq.topics.inner-broadcast.topic:}")
    private String innerBroadcastTopic;
    @Autowired
    private RocketMQTemplate rocketMQTemplate;

    public void sendInnerBroadcast(InnerBroadcastMessage message) {
        if (StringUtils.isBlank((CharSequence)this.innerBroadcastTopic)) {
            log.warn("rocketmq.topics.inner-broadcast.topic not configured!");
            return;
        }
        this.rocketMQTemplate.asyncSend(this.innerBroadcastTopic, (Object)message, new SendCallback(this){

            public void onSuccess(SendResult sendResult) {
            }

            public void onException(Throwable throwable) {
                log.error("Failed to send inner broadcast message to MQ!", throwable);
            }
        });
    }
}

