/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.metadata.service.impl;

import info.openmeta.framework.base.constant.BaseConstant;
import info.openmeta.framework.base.context.ContextHolder;
import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.orm.service.ModelService;
import info.openmeta.framework.web.dto.MetadataUpgradePackage;
import info.openmeta.starter.metadata.constant.MetadataConstant;
import info.openmeta.starter.metadata.message.InnerBroadcastProducer;
import info.openmeta.starter.metadata.message.dto.InnerBroadcastMessage;
import info.openmeta.starter.metadata.message.enums.InnerBroadcastType;
import info.openmeta.starter.metadata.service.MetadataService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MetadataServiceImpl
implements MetadataService {
    @Autowired
    private ModelService<Serializable> modelService;
    @Autowired
    private InnerBroadcastProducer innerBroadcastProducer;

    private void validateBatchSize(int size) {
        Assert.isTrue((Boolean)(size <= BaseConstant.MAX_BATCH_SIZE ? 1 : 0), (String)"The size of operation data cannot exceed the maximum {0} limit.", (Object[])new Object[]{BaseConstant.MAX_BATCH_SIZE});
    }

    private void validateRuntimeModel(String modelName) {
        Assert.isTrue((Boolean)MetadataConstant.BASIC_METADATA_MODELS.containsValue(modelName), (String)"Model {0} is not enabled for version control, and the upgrade API cannot be invoked.", (Object[])new Object[]{modelName});
    }

    private void createMetadata(String modelName, List<Map<String, Object>> createRows) {
        if (!CollectionUtils.isEmpty(createRows)) {
            this.validateBatchSize(createRows.size());
            this.modelService.createList(modelName, createRows);
        }
    }

    private void updateById(String modelName, List<Map<String, Object>> updateRows) {
        if (!CollectionUtils.isEmpty(updateRows)) {
            this.validateBatchSize(updateRows.size());
            this.modelService.updateList(modelName, updateRows);
        }
    }

    private void deleteById(String modelName, List<Serializable> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            this.validateBatchSize(ids.size());
            this.modelService.deleteList(modelName, ids);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void upgradeMetadata(List<MetadataUpgradePackage> metadataPackages) {
        metadataPackages.forEach(modelPackage -> {
            String modelName = modelPackage.getModelName();
            this.validateRuntimeModel(modelName);
            this.createMetadata(modelName, modelPackage.getCreateRows());
            this.updateById(modelName, modelPackage.getUpdateRows());
            this.deleteById(modelName, modelPackage.getDeleteIds());
        });
    }

    @Override
    public void reloadMetadata() {
        InnerBroadcastMessage message = new InnerBroadcastMessage();
        message.setBroadcastType(InnerBroadcastType.RELOAD_METADATA);
        message.setContext(ContextHolder.cloneContext());
        this.innerBroadcastProducer.sendInnerBroadcast(message);
    }
}

