/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.metadata.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import info.openmeta.framework.base.exception.IllegalArgumentException;
import info.openmeta.framework.base.exception.SystemException;
import info.openmeta.framework.base.utils.Assert;
import info.openmeta.framework.base.utils.Cast;
import info.openmeta.framework.base.utils.JsonMapper;
import info.openmeta.framework.orm.domain.Filters;
import info.openmeta.framework.orm.domain.FlexQuery;
import info.openmeta.framework.orm.enums.FieldType;
import info.openmeta.framework.orm.enums.FileType;
import info.openmeta.framework.orm.meta.MetaField;
import info.openmeta.framework.orm.meta.ModelManager;
import info.openmeta.framework.orm.service.ModelService;
import info.openmeta.framework.orm.service.impl.EntityServiceImpl;
import info.openmeta.framework.orm.utils.IdUtils;
import info.openmeta.framework.orm.utils.LambdaUtils;
import info.openmeta.framework.web.dto.FileInfo;
import info.openmeta.framework.web.utils.FileUtils;
import info.openmeta.starter.metadata.entity.SysPreData;
import info.openmeta.starter.metadata.service.SysPreDataService;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysPreDataServiceImpl
extends EntityServiceImpl<SysPreData, Long>
implements SysPreDataService {
    @Autowired
    protected ModelService<Serializable> modelService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void loadPredefinedData(List<String> fileNames) {
        String dataDir = "data/";
        for (String fileName : fileNames) {
            FileInfo fileInfo = FileUtils.getFileInfoByPath((String)dataDir, (String)fileName);
            this.loadFileInfo(fileInfo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void loadPredefinedData(MultipartFile file) {
        FileInfo fileInfo = FileUtils.getFileInfo((MultipartFile)file);
        this.loadFileInfo(fileInfo);
    }

    private void loadFileInfo(FileInfo fileInfo) {
        if (StringUtils.isBlank((CharSequence)fileInfo.getContent())) {
            return;
        }
        if (FileType.JSON.equals((Object)fileInfo.getFileType())) {
            this.processJson(fileInfo.getContent());
        } else if (FileType.XML.equals((Object)fileInfo.getFileType())) {
            this.processXml(fileInfo.getContent());
        } else if (FileType.CSV.equals((Object)fileInfo.getFileType())) {
            String fileName = fileInfo.getFileName();
            String modelName = fileName.substring(0, fileName.indexOf(46)).trim();
            Assert.isTrue((Boolean)ModelManager.existModel((String)modelName), (String)"Model {0} specified in the fileName `{1}` does not exist!", (Object[])new Object[]{modelName, fileName});
            this.processCsv(modelName, fileInfo.getContent());
        } else {
            throw new IllegalArgumentException("Unsupported file type for predefined data: {0}", new Object[]{fileInfo.getFileType()});
        }
    }

    private void processJson(String content) {
        Map predefinedData = (Map)JsonMapper.stringToObject((String)content, (TypeReference)new TypeReference<LinkedHashMap<String, Object>>(this){});
        predefinedData.forEach(this::processModelData);
    }

    private void processXml(String content) {
    }

    private void processCsv(String modelName, String content) {
        CSVParser parser;
        CSVFormat csvFormat = CSVFormat.Builder.create().setHeader(new String[0]).setSkipHeaderRecord(true).build();
        try {
            parser = csvFormat.parse((Reader)new StringReader(content));
        }
        catch (IOException e) {
            throw new SystemException("Failed to parse the CSV content: {0}", new Object[]{e.getMessage()});
        }
        Map headerMap = parser.getHeaderMap();
        ArrayList csvDataList = new ArrayList();
        for (CSVRecord record : parser) {
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            for (Map.Entry header : headerMap.entrySet()) {
                String fieldName = ((String)header.getKey()).trim();
                Assert.notBlank((String)fieldName, (String)"The field name in the CSV header cannot be empty!", (Object[])new Object[0]);
                String stringValue = record.get(((Integer)header.getValue()).intValue()).trim();
                FieldType fieldType = ModelManager.getModelField((String)modelName, (String)fieldName).getFieldType();
                if ("id".equals(fieldName) || FieldType.TO_ONE_TYPES.contains(fieldType)) {
                    rowData.put(fieldName, stringValue);
                    continue;
                }
                Object fieldValue = FieldType.convertStringToObject((FieldType)fieldType, (String)stringValue);
                rowData.put(fieldName, fieldValue);
            }
            csvDataList.add(rowData);
        }
        this.processModelData(modelName, csvDataList);
    }

    private void processModelData(String model, Object predefinedData) {
        ModelManager.validateModel((String)model);
        if (predefinedData instanceof List) {
            ((List)predefinedData).forEach(row -> {
                if (!(row instanceof Map)) {
                    throw new IllegalArgumentException("When defining model data in List structure, the internal data only supports Map format {0}: {1}", new Object[]{model, predefinedData});
                }
                this.handlePredefinedData(model, (Map)Cast.of((Object)row));
            });
        } else if (predefinedData instanceof Map) {
            this.handlePredefinedData(model, (Map)Cast.of((Object)predefinedData));
        } else {
            throw new IllegalArgumentException("Model predefined data only supports Map or List<Map> format {0}: {1}", new Object[]{model, predefinedData});
        }
    }

    private Serializable handlePredefinedData(String model, Map<String, Object> row) {
        LinkedHashMap<String, Object> oneToManyMap = new LinkedHashMap<String, Object>();
        Set<String> oneToManyFields = row.keySet().stream().filter(field -> FieldType.ONE_TO_MANY.equals((Object)ModelManager.getModelField((String)model, (String)field).getFieldType())).collect(Collectors.toSet());
        oneToManyFields.forEach(field -> oneToManyMap.put((String)field, row.remove(field)));
        Serializable rowId = this.createOrUpdateData(model, row);
        this.loadOneToManyRows(model, rowId, oneToManyMap);
        return rowId;
    }

    private void loadOneToManyRows(String model, Serializable mainId, Map<String, Object> oneToManyMap) {
        oneToManyMap.forEach((field, rows) -> {
            if (!(rows instanceof Collection)) {
                throw new IllegalArgumentException("The data of OneToMany field {0}:{1} must be a list: {2}", new Object[]{model, field, rows});
            }
            MetaField oneToManyMetaField = ModelManager.getModelField((String)model, (String)field);
            List<Serializable> manyIds = ((Collection)rows).stream().peek(item -> {
                if (!(item instanceof Map)) {
                    throw new IllegalArgumentException("The single predefined data of the OneToMany field {0}:{1} must be in Map format: {2}", new Object[]{model, field, item});
                }
            }).map(item -> {
                Map castedItem = (Map)Cast.of((Object)item);
                castedItem.put(oneToManyMetaField.getRelatedField(), mainId);
                return this.handlePredefinedData(oneToManyMetaField.getRelatedModel(), castedItem);
            }).toList();
            Filters deleteFilters = Filters.eq((String)oneToManyMetaField.getRelatedField(), (Object)mainId);
            if (!manyIds.isEmpty()) {
                deleteFilters.andNotIn("id", manyIds);
            }
            this.modelService.deleteByFilters(oneToManyMetaField.getRelatedModel(), deleteFilters);
        });
    }

    private Serializable createOrUpdateData(String model, Map<String, Object> row) {
        SysPreData preData = this.getPreDataByPreId(model, row);
        if (preData != null && Boolean.TRUE.equals(preData.getFrozen())) {
            return IdUtils.formatId((String)model, (Serializable)((Object)preData.getRowId()));
        }
        this.replaceReferencedPreIds(model, row);
        if (preData == null) {
            String preId = (String)row.get("id");
            row.remove("id");
            Serializable rowId = this.modelService.createOne(model, row);
            this.generatePreData(model, preId, rowId);
            return rowId;
        }
        Serializable rowId = IdUtils.formatId((String)model, (Serializable)((Object)preData.getRowId()));
        row.put("id", rowId);
        Set updatableStoredFields = ModelManager.getModelUpdatableFieldsWithoutXToMany((String)model);
        updatableStoredFields.removeAll(row.keySet());
        updatableStoredFields.forEach(field -> row.put((String)field, null));
        boolean result = this.modelService.updateOne(model, row);
        if (!Boolean.TRUE.equals(result)) {
            boolean isExist = this.modelService.exist(model, rowId);
            Assert.isTrue((Boolean)isExist, (String)"Updating predefined data for model {0} ({1}) failed as it has already been physically deleted!", (Object[])new Object[]{model, preData.getRowId()});
        }
        return preData.getRowId();
    }

    private SysPreData getPreDataByPreId(String model, Map<String, Object> row) {
        Assert.isTrue((Boolean)row.containsKey("id"), (String)"Predefined data for model {0} must include the preID: {1}", (Object[])new Object[]{model, row});
        Object preId = row.get("id");
        Assert.isTrue((Boolean)(preId instanceof String), (String)"Model {0} predefined data's preId must be of type String: {1}", (Object[])new Object[]{model, preId});
        Filters filters = Filters.eq(SysPreData::getModel, (Object)model).andEq(SysPreData::getPreId, preId);
        return (SysPreData)this.searchOne(new FlexQuery(filters));
    }

    private void replaceReferencedPreIds(String model, Map<String, Object> row) {
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            if (entry.getValue() == null) continue;
            MetaField metaField = ModelManager.getModelField((String)model, (String)entry.getKey());
            if (FieldType.TO_ONE_TYPES.contains(metaField.getFieldType()) && !(entry.getValue() instanceof Long) && !(entry.getValue() instanceof Integer)) {
                Assert.isTrue((Boolean)(entry.getValue() instanceof String), (String)"Model {0} field {1}:{2} preID must be of type String: {3}", (Object[])new Object[]{model, entry.getKey(), metaField.getFieldType().getType(), entry.getValue()});
                Serializable rowId = this.getOriginalRowIdByPreId(metaField.getRelatedModel(), (String)Cast.of((Object)entry.getValue()));
                entry.setValue(rowId);
                continue;
            }
            if (!FieldType.MANY_TO_MANY.equals((Object)metaField.getFieldType())) continue;
            Assert.isTrue((Boolean)(entry.getValue() instanceof Collection), (String)"Model {0} predefined data's {1} ManyToMany field value must be a list or empty", (Object[])new Object[]{model, entry.getKey()});
            if (CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) continue;
            List preIds = (List)Cast.of((Object)entry.getValue());
            List<Serializable> rowIds = this.getOriginalRowIdsByPreIds(metaField.getRelatedModel(), preIds);
            entry.setValue(rowIds);
        }
    }

    private Serializable getOriginalRowIdByPreId(String model, String preId) {
        Filters filters = Filters.eq(SysPreData::getModel, (Object)model).andEq(SysPreData::getPreId, (Object)preId);
        String rowIdField = LambdaUtils.getAttributeName(SysPreData::getRowId);
        List rowIds = this.getRelatedIds(filters, rowIdField);
        Assert.notEmpty((Collection)rowIds, (String)"The preID of the predefined data for model {0}: {1} does not exist in the predefined data table and may not have been created yet!", (Object[])new Object[]{model, preId});
        return IdUtils.formatId((String)model, (Serializable)((Serializable)rowIds.getFirst()));
    }

    private List<Serializable> getOriginalRowIdsByPreIds(String model, List<String> preIds) {
        Filters filters = Filters.eq(SysPreData::getModel, (Object)model).andIn(SysPreData::getPreId, preIds);
        String rowIdField = LambdaUtils.getAttributeName(SysPreData::getRowId);
        List rowIds = this.getRelatedIds(filters, rowIdField);
        Assert.notEmpty((Collection)rowIds, (String)"The preIDs of the predefined data for model {0}: {1} do not exist in the predefined data table and may not have been created yet!", (Object[])new Object[]{model, preIds});
        return IdUtils.formatIds((String)model, (List)rowIds);
    }

    private void generatePreData(String model, String preId, Serializable rowId) {
        SysPreData preData = new SysPreData();
        preData.setModel(model);
        preData.setPreId(preId);
        preData.setRowId(rowId.toString());
        this.createOne(preData);
    }
}

