/*
 * Decompiled with CFR 0.152.
 */
package info.openmeta.starter.metadata.service.impl;

import info.openmeta.framework.base.context.ContextHolder;
import info.openmeta.framework.base.enums.Operator;
import info.openmeta.framework.orm.domain.Filters;
import info.openmeta.framework.orm.domain.FlexQuery;
import info.openmeta.framework.orm.domain.Orders;
import info.openmeta.framework.orm.entity.BaseModel;
import info.openmeta.framework.orm.service.impl.EntityServiceImpl;
import info.openmeta.starter.metadata.entity.SysView;
import info.openmeta.starter.metadata.entity.SysViewDefault;
import info.openmeta.starter.metadata.service.SysViewDefaultService;
import info.openmeta.starter.metadata.service.SysViewService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysViewServiceImpl
extends EntityServiceImpl<SysView, Long>
implements SysViewService {
    @Autowired
    private SysViewDefaultService viewDefaultService;

    @Override
    public boolean setDefaultView(String modelName, Long viewId) {
        Long currentUserId = ContextHolder.getContext().getUserId();
        Filters personalFilters = Filters.eq(SysViewDefault::getModelName, (Object)modelName).andEq(BaseModel::getCreatedId, (Object)currentUserId);
        SysViewDefault defaultView = (SysViewDefault)this.viewDefaultService.searchOne(new FlexQuery(personalFilters));
        if (defaultView != null) {
            defaultView.setViewId(viewId);
            return this.viewDefaultService.updateOne(defaultView);
        }
        defaultView = new SysViewDefault();
        defaultView.setModelName(modelName);
        defaultView.setViewId(viewId);
        defaultView.setCreatedId(currentUserId);
        return this.viewDefaultService.createOne(defaultView) != null;
    }

    @Override
    public List<SysView> getModelViews(String modelName) {
        Long currentUserId = ContextHolder.getContext().getUserId();
        Filters viewFilters = Filters.of(SysView::getModelName, (Operator)Operator.EQUAL, (Object)modelName).and(Filters.of(SysView::getPublicView, (Operator)Operator.EQUAL, (Object)true).or(BaseModel::getCreatedId, Operator.EQUAL, (Object)currentUserId));
        Orders orders = Orders.ofDesc(SysView::getPublicView).addAsc(SysView::getSequence);
        List views = this.searchList(new FlexQuery(viewFilters, orders));
        Filters personalFilters = Filters.of(SysViewDefault::getModelName, (Operator)Operator.EQUAL, (Object)modelName).and(BaseModel::getCreatedId, Operator.EQUAL, (Object)currentUserId);
        SysViewDefault defaultView = (SysViewDefault)this.viewDefaultService.searchOne(new FlexQuery(personalFilters));
        if (defaultView != null) {
            views.forEach(v -> v.setDefaultView(v.getId().equals(defaultView.getViewId())));
        }
        return views;
    }
}

