/*
 * Decompiled with CFR 0.152.
 */
package info.solidsoft.mockito.java8.api;

import info.solidsoft.mockito.java8.api.WithMatchers;
import org.mockito.InOrder;
import org.mockito.Incubating;
import org.mockito.MockSettings;
import org.mockito.MockingDetails;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.stubbing.Stubber;
import org.mockito.verification.VerificationAfterDelay;
import org.mockito.verification.VerificationMode;
import org.mockito.verification.VerificationWithTimeout;

@Incubating
public interface WithMockito
extends WithMatchers {
    default public <T> T mock(Class<T> classToMock) {
        return (T)Mockito.mock(classToMock);
    }

    default public <T> T mock(Class<T> classToMock, String name) {
        return (T)Mockito.mock(classToMock, (String)name);
    }

    default public MockingDetails mockingDetails(Object toInspect) {
        return Mockito.mockingDetails((Object)toInspect);
    }

    default public <T> T mock(Class<T> classToMock, Answer defaultAnswer) {
        return (T)Mockito.mock(classToMock, (Answer)defaultAnswer);
    }

    default public <T> T mock(Class<T> classToMock, MockSettings mockSettings) {
        return (T)Mockito.mock(classToMock, (MockSettings)mockSettings);
    }

    default public <T> T spy(T object) {
        return (T)Mockito.spy(object);
    }

    @Incubating
    default public <T> T spy(Class<T> classToSpy) {
        return (T)Mockito.spy(classToSpy);
    }

    default public <T> OngoingStubbing<T> when(T methodCall) {
        return Mockito.when(methodCall);
    }

    default public <T> T verify(T mock) {
        return (T)Mockito.verify(mock, (VerificationMode)this.times(1));
    }

    default public <T> T verify(T mock, VerificationMode mode) {
        return (T)Mockito.verify(mock, (VerificationMode)mode);
    }

    default public <T> void reset(T ... mocks) {
        Mockito.reset((Object[])mocks);
    }

    default public void verifyNoMoreInteractions(Object ... mocks) {
        Mockito.verifyNoMoreInteractions((Object[])mocks);
    }

    default public void verifyZeroInteractions(Object ... mocks) {
        Mockito.verifyNoMoreInteractions((Object[])mocks);
    }

    default public Stubber doThrow(Throwable ... toBeThrown) {
        return Mockito.doThrow((Throwable[])toBeThrown);
    }

    default public Stubber doThrow(Class<? extends Throwable> toBeThrown) {
        return Mockito.doThrow(toBeThrown);
    }

    default public Stubber doCallRealMethod() {
        return Mockito.doCallRealMethod();
    }

    default public Stubber doAnswer(Answer answer) {
        return Mockito.doAnswer((Answer)answer);
    }

    default public Stubber doNothing() {
        return Mockito.doNothing();
    }

    default public Stubber doReturn(Object toBeReturned) {
        return Mockito.doReturn((Object)toBeReturned);
    }

    default public Stubber doReturn(Object toBeReturned, Object ... toBeReturnedNext) {
        return Mockito.doReturn((Object)toBeReturned, (Object[])toBeReturnedNext);
    }

    default public InOrder inOrder(Object ... mocks) {
        return Mockito.inOrder((Object[])mocks);
    }

    default public Object[] ignoreStubs(Object ... mocks) {
        return Mockito.ignoreStubs((Object[])mocks);
    }

    default public VerificationMode times(int wantedNumberOfInvocations) {
        return Mockito.times((int)wantedNumberOfInvocations);
    }

    default public VerificationMode never() {
        return Mockito.never();
    }

    default public VerificationMode atLeastOnce() {
        return Mockito.atLeastOnce();
    }

    default public VerificationMode atLeast(int minNumberOfInvocations) {
        return Mockito.atLeast((int)minNumberOfInvocations);
    }

    default public VerificationMode atMost(int maxNumberOfInvocations) {
        return Mockito.atMost((int)maxNumberOfInvocations);
    }

    default public VerificationMode calls(int wantedNumberOfInvocations) {
        return Mockito.calls((int)wantedNumberOfInvocations);
    }

    default public VerificationMode only() {
        return Mockito.only();
    }

    default public VerificationWithTimeout timeout(long millis) {
        return Mockito.timeout((long)millis);
    }

    default public VerificationAfterDelay after(long millis) {
        return Mockito.after((long)millis);
    }

    default public void validateMockitoUsage() {
        Mockito.validateMockitoUsage();
    }

    default public MockSettings withSettings() {
        return Mockito.withSettings();
    }

    default public VerificationMode description(String description) {
        return Mockito.description((String)description);
    }
}

