/*
 * Decompiled with CFR 0.152.
 */
package com.cory.db.config;

import com.cory.db.config.CoryDbProperties;
import com.cory.db.jdbc.CoryDb;
import com.cory.db.jdbc.RealCoryDb;
import com.cory.db.processor.CoryDbChecker;
import com.cory.db.processor.CoryDbDaoProcessor;
import com.cory.db.processor.CoryDbInitializer;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ConditionalOnProperty(prefix="cory.db", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={CoryDbProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@ConditionalOnBean(value={DataSource.class})
@EnableTransactionManagement(proxyTargetClass=true)
public class CoryDbAutoConfiguration {
    @Bean
    public JdbcTemplate jdbcTemplate(DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean
    @ConditionalOnBean(value={DataSource.class})
    public CoryDb coryDb(JdbcTemplate jdbcTemplate) {
        return new RealCoryDb(jdbcTemplate);
    }

    @Bean
    public CoryDbDaoProcessor coryDbDaoProcessor() {
        return new CoryDbDaoProcessor();
    }

    @Bean
    public CoryDbChecker coryDbChecker(CoryDbProperties coryDbProperties, CoryDb coryDb, @Value(value="${spring.datasource.name}") String database) {
        return new CoryDbChecker(coryDb, coryDbProperties, database);
    }

    @Bean
    @DependsOn(value={"coryDbChecker"})
    public CoryDbInitializer coryDbInitializer(CoryDb coryDb, CoryDbProperties coryDbProperties) {
        return new CoryDbInitializer(coryDb, coryDbProperties);
    }
}

