/*
 * Decompiled with CFR 0.152.
 */
package com.cory.db.config;

import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="cory.db")
public class CoryDbProperties {
    private boolean enable = true;
    private String[] daoPackages = new String[]{"com.cory.dao"};
    private String[] modelPackages = new String[]{"com.cory.model"};
    private boolean logEnable = true;

    public boolean isEnable() {
        return this.enable;
    }

    public String[] getDaoPackages() {
        return this.daoPackages;
    }

    public String[] getModelPackages() {
        return this.modelPackages;
    }

    public boolean isLogEnable() {
        return this.logEnable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setDaoPackages(String[] daoPackages) {
        this.daoPackages = daoPackages;
    }

    public void setModelPackages(String[] modelPackages) {
        this.modelPackages = modelPackages;
    }

    public void setLogEnable(boolean logEnable) {
        this.logEnable = logEnable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoryDbProperties)) {
            return false;
        }
        CoryDbProperties other = (CoryDbProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        if (this.isLogEnable() != other.isLogEnable()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getDaoPackages(), other.getDaoPackages())) {
            return false;
        }
        return Arrays.deepEquals(this.getModelPackages(), other.getModelPackages());
    }

    protected boolean canEqual(Object other) {
        return other instanceof CoryDbProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        result = result * 59 + (this.isLogEnable() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getDaoPackages());
        result = result * 59 + Arrays.deepHashCode(this.getModelPackages());
        return result;
    }

    public String toString() {
        return "CoryDbProperties(enable=" + this.isEnable() + ", daoPackages=" + Arrays.deepToString(this.getDaoPackages()) + ", modelPackages=" + Arrays.deepToString(this.getModelPackages()) + ", logEnable=" + this.isLogEnable() + ")";
    }
}

