/*
 * Decompiled with CFR 0.152.
 */
package com.cory.db.jdbc;

import org.apache.commons.lang3.StringUtils;

public class Column {
    private String name;
    private String tableName;
    private String defaultValue;
    private boolean nullable;
    private String columnType;
    private String columnComment;

    public boolean equals(Object o) {
        if (!(o instanceof Column)) {
            return false;
        }
        Column c = (Column)o;
        return StringUtils.equals((CharSequence)this.name.toUpperCase(), (CharSequence)c.name.toUpperCase()) && StringUtils.equals((CharSequence)this.tableName.toUpperCase(), (CharSequence)c.tableName.toUpperCase()) && StringUtils.equals((CharSequence)this.defaultValue, (CharSequence)c.defaultValue) && this.nullable == c.nullable && StringUtils.equals((CharSequence)this.columnType.toUpperCase().replaceAll("\\(.*?\\)", ""), (CharSequence)c.columnType.toUpperCase().replaceAll("\\(.*?\\)", ""));
    }

    public int hashCode() {
        return this.name.hashCode() + this.tableName.hashCode() * 31 + (null == this.defaultValue ? 0 : this.defaultValue.hashCode() * 13) + Boolean.valueOf(this.nullable).hashCode() * 17 + this.columnType.hashCode() * 11;
    }

    public String buildDDL() {
        String na = this.nullable ? "NULL" : "NOT NULL";
        String dv = StringUtils.isBlank((CharSequence)this.defaultValue) ? "" : "DEFAULT '" + this.defaultValue + "'";
        String cc = StringUtils.isBlank((CharSequence)this.columnComment) ? "" : "COMMENT '" + this.columnComment + "'";
        return String.format("`%s` %s %s %s %s", this.name, this.columnType, na, dv, cc);
    }

    public static ColumnBuilder builder() {
        return new ColumnBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public String getColumnComment() {
        return this.columnComment;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public void setColumnType(String columnType) {
        this.columnType = columnType;
    }

    public void setColumnComment(String columnComment) {
        this.columnComment = columnComment;
    }

    public String toString() {
        return "Column(name=" + this.getName() + ", tableName=" + this.getTableName() + ", defaultValue=" + this.getDefaultValue() + ", nullable=" + this.isNullable() + ", columnType=" + this.getColumnType() + ", columnComment=" + this.getColumnComment() + ")";
    }

    public Column() {
    }

    public Column(String name, String tableName, String defaultValue, boolean nullable, String columnType, String columnComment) {
        this.name = name;
        this.tableName = tableName;
        this.defaultValue = defaultValue;
        this.nullable = nullable;
        this.columnType = columnType;
        this.columnComment = columnComment;
    }

    public static class ColumnBuilder {
        private String name;
        private String tableName;
        private String defaultValue;
        private boolean nullable;
        private String columnType;
        private String columnComment;

        ColumnBuilder() {
        }

        public ColumnBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ColumnBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public ColumnBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public ColumnBuilder nullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public ColumnBuilder columnType(String columnType) {
            this.columnType = columnType;
            return this;
        }

        public ColumnBuilder columnComment(String columnComment) {
            this.columnComment = columnComment;
            return this;
        }

        public Column build() {
            return new Column(this.name, this.tableName, this.defaultValue, this.nullable, this.columnType, this.columnComment);
        }

        public String toString() {
            return "Column.ColumnBuilder(name=" + this.name + ", tableName=" + this.tableName + ", defaultValue=" + this.defaultValue + ", nullable=" + this.nullable + ", columnType=" + this.columnType + ", columnComment=" + this.columnComment + ")";
        }
    }
}

