/*
 * Decompiled with CFR 0.152.
 */
package com.cory.db.jdbc;

import com.cory.constant.ErrorCode;
import com.cory.context.CurrentUser;
import com.cory.db.annotations.Dao;
import com.cory.db.annotations.Delete;
import com.cory.db.annotations.Insert;
import com.cory.db.annotations.Model;
import com.cory.db.annotations.Param;
import com.cory.db.annotations.Select;
import com.cory.db.annotations.Sql;
import com.cory.db.annotations.Update;
import com.cory.db.annotations.UpdateModel;
import com.cory.db.datapermission.DataPermission;
import com.cory.db.datapermission.DataPermissionResult;
import com.cory.db.datapermission.DataPermissionStrategy;
import com.cory.db.enums.CustomSqlType;
import com.cory.db.jdbc.CoryDb;
import com.cory.db.jdbc.CoryModelUtil;
import com.cory.db.jdbc.CorySqlBuilder;
import com.cory.db.jdbc.mapper.ResultMapper;
import com.cory.db.jdbc.mapper.ResultMapperFactory;
import com.cory.enums.CoryEnum;
import com.cory.exception.CoryException;
import com.cory.model.BaseModel;
import com.cory.page.Pagination;
import com.cory.util.AssertUtils;
import com.cory.util.ClassUtil;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoryDbProxy<T>
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(CoryDbProxy.class);
    private static final String DAO_MISSING_ANNOTATION_MSG = "Dao\u65b9\u6cd5\u4e0a\uff0c\u6ce8\u89e3Insert\u3001Update\u3001Delete\u3001Select\u3001UpdateModel\u3001Sql\u5fc5\u987b\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a";
    private static final String CODE = "code";
    private static final String GET_BY_CODE = "getByCode";
    private static final String GET_BY_CODE_LIST = "getByCodeList";
    private CoryDb coryDb;
    private Class<T> daoClass;
    private Class<? extends BaseModel> modelClass;
    private String table;
    private boolean noTable;
    private boolean logEnable;
    private boolean logicDelete;
    private Map<String, DataPermission> dataPermissionCodeMap = new HashMap<String, DataPermission>();

    public CoryDbProxy(Class<T> daoClass, CoryDb coryDb, boolean logEnable, List<DataPermission> dataPermissionList) {
        this.daoClass = daoClass;
        this.coryDb = coryDb;
        this.logEnable = logEnable;
        if (CollectionUtils.isNotEmpty(dataPermissionList)) {
            dataPermissionList.forEach(dp -> this.dataPermissionCodeMap.put(dp.code(), (DataPermission)dp));
        }
        Dao dao = daoClass.getAnnotation(Dao.class);
        this.modelClass = dao.model();
        Model model = this.modelClass.getAnnotation(Model.class);
        this.noTable = null == model ? false : model.noTable();
        this.table = CoryModelUtil.buildTableName(this.modelClass);
        this.logicDelete = model.logicDelete();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        Insert insert = method.getAnnotation(Insert.class);
        Update update = method.getAnnotation(Update.class);
        Delete delete = method.getAnnotation(Delete.class);
        Select select = method.getAnnotation(Select.class);
        UpdateModel updateModel = method.getAnnotation(UpdateModel.class);
        Sql sql = method.getAnnotation(Sql.class);
        int opCount = (null == insert ? 0 : 1) + (null == update ? 0 : 1) + (null == delete ? 0 : 1) + (null == select ? 0 : 1) + (null == updateModel ? 0 : 1) + (null == sql ? 0 : 1);
        AssertUtils.isTrue((opCount == 1 ? 1 : 0) != 0, (String)DAO_MISSING_ANNOTATION_MSG, (ErrorCode)ErrorCode.DB_ERROR);
        if (this.noTable && null == sql) {
            AssertUtils.isTrue((boolean)false, (String)"noTable\u65f6\u53ea\u80fd\u6709\u7528Sql\u6ce8\u89e3\u7684\u65b9\u6cd5.", (ErrorCode)ErrorCode.DB_ERROR);
        }
        if (null != insert) {
            return this.insert(method, args, insert);
        }
        if (null != update) {
            return this.update(method, args, update);
        }
        if (null != delete) {
            return this.delete(method, args, delete);
        }
        if (null != select) {
            return this.select(method, args, select);
        }
        if (null != updateModel) {
            return this.updateModel(method, args, updateModel);
        }
        if (null != sql) {
            return this.executeCustomSql(method, args, sql);
        }
        throw new CoryException(ErrorCode.DB_ERROR, new Object[]{DAO_MISSING_ANNOTATION_MSG});
    }

    private Object executeCustomSql(Method method, Object[] args, Sql sql) {
        AssertUtils.isTrue((null != args && args.length == 1 && args[0].getClass().equals(String.class) ? 1 : 0) != 0, (String)"Sql\u65f6\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u7c7b\u578b\u662fString\u7684\u53c2\u6570", (ErrorCode)ErrorCode.DB_ERROR);
        String sqlValue = (String)args[0];
        if (this.logEnable) {
            log.info("type: {}, sql: {}", (Object)sql.type().name(), (Object)sqlValue);
        }
        if (CustomSqlType.DDL.equals((Object)sql.type())) {
            AssertUtils.isTrue((boolean)method.getReturnType().equals(Void.TYPE), (String)"DDL Sql\u8fd4\u56de\u503c\u7c7b\u578b\u5fc5\u987b\u662fvoid", (ErrorCode)ErrorCode.DB_ERROR);
            this.coryDb.executeSql(sqlValue);
            return Void.TYPE;
        }
        if (CustomSqlType.EXECUTE.equals((Object)sql.type())) {
            AssertUtils.isTrue((boolean)method.getReturnType().equals(Integer.TYPE), (String)"Sql\u65f6\u8fd4\u56de\u503c\u7c7b\u578b\u5fc5\u987b\u662fint", (ErrorCode)ErrorCode.DB_ERROR);
            return this.coryDb.update(sqlValue);
        }
        if (CustomSqlType.QUERY.equals((Object)sql.type())) {
            AssertUtils.isTrue((boolean)method.getReturnType().equals(List.class), (String)"Sql\u65f6\u8fd4\u56de\u503c\u7c7b\u578b\u5fc5\u987b\u662fList<Map<String, Object>>", (ErrorCode)ErrorCode.DB_ERROR);
            return this.coryDb.query(sqlValue);
        }
        throw new CoryException(ErrorCode.DB_ERROR, new Object[]{"sql\u7c7b\u578b\u9519\u8bef!"});
    }

    private int updateModel(Method method, Object[] args, UpdateModel updateModel) {
        AssertUtils.isTrue((null != args && args.length == 1 && args[0].getClass().equals(this.modelClass) ? 1 : 0) != 0, (String)("UpdateModel\u65f6\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u7c7b\u578b\u662f\uff1a" + this.modelClass + "\u7684\u53c2\u6570"), (ErrorCode)ErrorCode.DB_ERROR);
        Object model = args[0];
        if (model instanceof BaseModel) {
            this.resetDateAndOperator((BaseModel)model);
        }
        Map<String, Object> columns = CoryModelUtil.parseModelFieldsValueWithBaseModel(model, this.modelClass);
        CorySqlBuilder.CoryUpdateModelSqlBuilder builder = CorySqlBuilder.createUpdateModelBuilder(this.table);
        if (MapUtils.isNotEmpty(columns)) {
            columns.entrySet().forEach(entry -> builder.column((String)entry.getKey(), this.toValue(entry.getValue())));
        }
        CorySqlBuilder.CorySqlInfo sqlInfo = builder.build();
        if (this.logEnable) {
            log.info(sqlInfo.toString());
        }
        return this.coryDb.update(sqlInfo);
    }

    private Object select(Method method, Object[] args, Select select) {
        Object model;
        this.checkForSelectByCodeMethod(method);
        if (method.getName().equals(GET_BY_CODE) && (null == args || args.length == 0 || null == args[0])) {
            return null;
        }
        if (method.getName().equals(GET_BY_CODE_LIST) && (null == args || args.length == 0)) {
            return new ArrayList();
        }
        this.checkForSelectCount(method, select.count());
        Map<String, Object> paramMap = this.buildNotNullParamMap(method, args);
        DataPermissionResult dataPermissionResult = this.calculateDataPermissionResult(select, paramMap);
        CorySqlBuilder.CorySelectSqlBuilder builder = CorySqlBuilder.createSelectBuilder(this.table, select.whereSql(), select.whereByModel(), select.orderBy(), select.limit(), select.customSql(), paramMap, dataPermissionResult);
        if (select.whereByModel() && null != (model = paramMap.get("model"))) {
            Map columns = ClassUtil.fetchProperties((Object)model, this.modelClass, com.cory.db.annotations.Field.class);
            if (MapUtils.isNotEmpty((Map)columns)) {
                columns.entrySet().stream().filter(entry -> null != entry.getValue()).forEach(entry -> builder.column((String)entry.getKey(), this.toValue(entry.getValue())));
            }
            if (model instanceof BaseModel) {
                BaseModel baseModel = (BaseModel)model;
                if (MapUtils.isNotEmpty((Map)baseModel.getFilterFieldMap())) {
                    baseModel.getFilterFieldMap().keySet().forEach(key -> baseModel.getFilterFieldMap().put(key, this.toValue(baseModel.getFilterFieldMap().get(key))));
                }
                if (null != baseModel.getId() && baseModel.getId() > 0) {
                    builder.column("id", baseModel.getId());
                }
            }
        }
        CorySqlBuilder.CorySqlInfo dataSqlInfo = builder.buildDataSql();
        if (this.logEnable) {
            log.info(dataSqlInfo.toString());
        }
        if (select.count()) {
            CorySqlBuilder.CorySqlInfo countSqlInfo = builder.buildCountSql();
            if (this.logEnable) {
                log.info(countSqlInfo.toString());
            }
            return countSqlInfo.getSelectDenied() != false ? 0 : this.coryDb.selectCount(countSqlInfo);
        }
        Class selectReturnType = select.returnType();
        Class<?> returnType = method.getReturnType();
        if (returnType.equals(Pagination.class)) {
            CorySqlBuilder.CorySqlInfo countSqlInfo = builder.buildCountSql();
            if (this.logEnable) {
                log.info(countSqlInfo.toString());
            }
            int count = countSqlInfo.getSelectDenied() != false ? 0 : this.coryDb.selectCount(countSqlInfo);
            Pagination p = new Pagination();
            Class cls = ClassUtil.parseGenericType(returnType);
            if (null == cls || cls.equals(Object.class)) {
                cls = null != selectReturnType && !Void.class.equals((Object)selectReturnType) ? selectReturnType : this.modelClass;
            }
            p.setTotalCount(count);
            if (count > 0) {
                List<Map<String, Object>> listData = this.coryDb.select(dataSqlInfo);
                p.setList((List)((ResultMapper)ResultMapperFactory.parseMapper(List.class, this.modelClass, selectReturnType).getLeft()).map(listData, cls));
            }
            return p;
        }
        ArrayList listData = dataSqlInfo.getSelectDenied() != false ? Lists.newArrayList() : this.coryDb.select(dataSqlInfo);
        Pair<ResultMapper, Class<?>> pair = ResultMapperFactory.parseMapper(returnType, this.modelClass, selectReturnType);
        return ((ResultMapper)pair.getLeft()).map(listData, (Class)pair.getRight());
    }

    private DataPermissionResult calculateDataPermissionResult(Select select, Map<String, Object> paramMap) {
        if (MapUtils.isEmpty(this.dataPermissionCodeMap)) {
            return null;
        }
        String[] codeArr = select.dataPermission();
        if (null == codeArr || codeArr.length == 0) {
            return null;
        }
        if (codeArr.length == 1) {
            DataPermission permission = this.dataPermissionCodeMap.get(codeArr[0]);
            AssertUtils.notNull((Object)permission, (String)"db.data.permission.error", (String)"invalid data permission: no data permission implement");
            return permission.permission(paramMap);
        }
        boolean pass = true;
        boolean deny = false;
        StringBuilder sql = new StringBuilder();
        for (String code : codeArr) {
            DataPermission permission = this.dataPermissionCodeMap.get(code);
            AssertUtils.notNull((Object)permission, (String)"db.data.permission.error", (String)"invalid data permission: no data permission implement");
            DataPermissionResult result = permission.permission(paramMap);
            if (DataPermissionStrategy.DENY.equals((Object)result.getStrategy())) {
                pass = false;
                deny = true;
                break;
            }
            if (!DataPermissionStrategy.FILTER.equals((Object)result.getStrategy())) continue;
            pass = false;
            sql.append("(").append(result.getFilterSql()).append(") AND");
        }
        if (sql.length() > 0) {
            sql.delete(sql.length() - 3, sql.length());
        }
        return DataPermissionResult.builder().filterSql(pass || deny ? null : sql.toString()).strategy(deny ? DataPermissionStrategy.DENY : (pass ? DataPermissionStrategy.PASS : DataPermissionStrategy.FILTER)).build();
    }

    private void checkForSelectCount(Method method, boolean count) {
        if (!count) {
            return;
        }
        AssertUtils.isTrue((boolean)Integer.class.equals(method.getReturnType()), (String)"\u67e5\u8be2\u8bb0\u5f55\u6570(count = true)\u65f6\uff0c\u8fd4\u56de\u503c\u5fc5\u987b\u662fInteger", (ErrorCode)ErrorCode.DB_ERROR);
    }

    private void checkForSelectByCodeMethod(Method method) {
        if (!method.getName().equals(GET_BY_CODE_LIST) && !method.getName().equals(GET_BY_CODE)) {
            return;
        }
        CoryException ex = new CoryException(ErrorCode.DB_ERROR, new Object[]{"model\u7c7b" + this.modelClass + "\u6ca1\u6709code\u5b57\u6bb5(\u5e76\u4e14\u9700\u8981\u52a0\u4e0aField\u6ce8\u89e3)\uff0c\u4e0d\u80fd\u8c03\u7528" + method.getName() + "\u65b9\u6cd5"});
        try {
            Field javaField = this.modelClass.getDeclaredField(CODE);
            if (null == javaField || !javaField.isAnnotationPresent(com.cory.db.annotations.Field.class)) {
                throw ex;
            }
        }
        catch (NoSuchFieldException e) {
            throw ex;
        }
    }

    private int delete(Method method, Object[] args, Delete delete) {
        Map<String, Object> paramMap = this.buildNotNullParamMap(method, args);
        CorySqlBuilder.CorySqlInfo sqlInfo = CorySqlBuilder.createDeleteBuilder(this.table, delete.whereSql(), this.logicDelete, paramMap).build();
        if (this.logEnable) {
            log.info(sqlInfo.toString());
        }
        return this.coryDb.delete(sqlInfo);
    }

    private int update(Method method, Object[] args, Update update) {
        Map<String, Object> paramMap = this.buildNotNullParamMap(method, args);
        CorySqlBuilder.CorySqlInfo sqlInfo = CorySqlBuilder.createUpdateBuilder(this.table, update.columnSql(), update.whereSql(), paramMap).build();
        if (this.logEnable) {
            log.info(sqlInfo.toString());
        }
        return this.coryDb.update(sqlInfo);
    }

    private Object insert(Method method, Object[] args, Insert insert) {
        AssertUtils.isTrue((null != args && args.length == 1 && args[0].getClass().equals(this.modelClass) ? 1 : 0) != 0, (String)("\u63d2\u5165\u65f6\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u7c7b\u578b\u662f\uff1a" + this.modelClass + "\u7684\u53c2\u6570"), (ErrorCode)ErrorCode.DB_ERROR);
        Object model = args[0];
        if (model instanceof BaseModel) {
            this.resetDateAndOperator((BaseModel)model);
        }
        Map<String, Object> columns = CoryModelUtil.parseModelFieldsValueWithBaseModel(model, this.modelClass);
        CorySqlBuilder.CoryInsertSqlBuilder builder = CorySqlBuilder.createInsertBuilder(this.table);
        if (MapUtils.isNotEmpty(columns)) {
            columns.entrySet().forEach(entry -> builder.column((String)entry.getKey(), this.toValue(entry.getValue())));
        }
        CorySqlBuilder.CorySqlInfo sqlInfo = builder.build();
        if (this.logEnable) {
            log.info(sqlInfo.toString());
        }
        int id = this.coryDb.insert(sqlInfo);
        if (model instanceof BaseModel) {
            ((BaseModel)model).setId(Integer.valueOf(id));
        }
        return Void.TYPE;
    }

    private void resetDateAndOperator(BaseModel model) {
        CurrentUser user = CurrentUser.get();
        if (null == model.getCreator()) {
            model.setCreator(Integer.valueOf(null == user || null == user.getId() ? 1 : user.getId()));
        }
        if (null == model.getModifier()) {
            model.setModifier(Integer.valueOf(null == user || null == user.getId() ? 1 : user.getId()));
        }
        if (null == model.getCreateTime()) {
            model.setCreateTime(new Date());
        }
        if (null == model.getModifyTime()) {
            model.setModifyTime(new Date());
        }
    }

    public static <T> T newMapperProxy(Class<T> daoClass, CoryDb coryDb, boolean logEnable, List<DataPermission> dataPermissionList) {
        ClassLoader classLoader = daoClass.getClassLoader();
        Class[] interfaces = new Class[]{daoClass};
        CoryDbProxy<T> proxy = new CoryDbProxy<T>(daoClass, coryDb, logEnable, dataPermissionList);
        return (T)Proxy.newProxyInstance(classLoader, interfaces, proxy);
    }

    private Map<String, Object> buildNotNullParamMap(Method method, Object[] args) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (null == args || args.length == 0) {
            return paramMap;
        }
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < args.length; ++i) {
            Parameter parameter = parameters[i];
            Param param = parameter.getAnnotation(Param.class);
            AssertUtils.notNull((Object)param, (String)("\u53c2\u6570(" + parameter.getName() + ")\u5fc5\u987b\u5199Param\u6ce8\u89e3"), (ErrorCode)ErrorCode.DB_ERROR);
            paramMap.put(param.value(), this.toValue(args[i]));
        }
        return paramMap;
    }

    private Object toValue(Object o) {
        List list;
        if (null == o) {
            return null;
        }
        if (o instanceof CoryEnum) {
            return ((CoryEnum)o).name();
        }
        if (o instanceof List && (list = (List)o).size() > 0 && list.get(0) instanceof CoryEnum) {
            return list.stream().map(i -> ((CoryEnum)i).name()).collect(Collectors.toList());
        }
        return o;
    }

    public static void main(String[] args) {
        ArrayList l = Lists.newArrayList((Object[])new Integer[]{1, 2, 3});
        System.out.println(List.class.isAssignableFrom(l.getClass()));
        System.out.println(l instanceof List);
    }
}

