/*
 * Decompiled with CFR 0.152.
 */
package com.cory.db.jdbc;

import com.cory.constant.Constants;
import com.cory.db.annotations.Field;
import com.cory.db.annotations.Model;
import com.cory.model.BaseModel;
import com.cory.util.ClassUtil;
import com.google.common.base.CaseFormat;
import java.util.Map;

public class CoryModelUtil {
    public static String buildTableName(Class<? extends BaseModel> modelClass) {
        Model model = modelClass.getAnnotation(Model.class);
        String modelName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, modelClass.getSimpleName());
        return model.module() + "_" + modelName;
    }

    public static String buildColumnName(String javaFieldName) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, javaFieldName);
    }

    public static Map<String, Object> parseModelFieldsValueWithBaseModel(Object object, Class modelClass) {
        Map columns = ClassUtil.fetchProperties((Object)object, (Class)modelClass, Field.class);
        Map baseColumns = ClassUtil.fetchProperties((Object)object, (Class)modelClass, null);
        for (String c : Constants.BASE_MODEL_COLUMNS) {
            Object value = baseColumns.get(c);
            columns.put(c, value);
        }
        return columns;
    }
}

