/*
 * Decompiled with CFR 0.152.
 */
package com.cory.db.jdbc;

import com.alibaba.fastjson.JSON;
import com.cory.constant.ErrorCode;
import com.cory.db.datapermission.DataPermissionResult;
import com.cory.db.datapermission.DataPermissionStrategy;
import com.cory.db.jdbc.CoryModelUtil;
import com.cory.exception.CoryException;
import com.cory.model.BaseModel;
import com.cory.util.AssertUtils;
import com.cory.util.MapBuilder;
import com.google.common.base.CaseFormat;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CorySqlBuilder {
    private static final String ID = "ID";
    private static final String CREATOR = "CREATOR";
    private static final String MODIFIER = "MODIFIER";
    private static final String CREATE_TIME = "CREATE_TIME";
    private static final String MODIFY_TIME = "MODIFY_TIME";
    private static final String IS_DELETED = "IS_DELETED";
    private static final String PARAM_SORT = "sort";
    private static final String PARAM_PAGE_START = "pageStart";
    private static final String PARAM_PAGE_SIZE = "pageSize";
    private static final String COMMA = ",";
    private static final String SPACE = " ";
    private static final String EQUAL = "=";
    private static final String QUESTION_MARK = "?";
    private static final Pattern PARAM_PATTERN_REG = Pattern.compile("#\\{.*?}");
    private static final Pattern NULLABLE_PARAM_PATTERN_REG = Pattern.compile("#!\\[.*?]");
    private static final String PARAM_PATTERN_FULL = ".*?#\\{.*?}.*";
    private static final String NULLABLE_PARAM_PATTERN_FULL = ".*?#!\\[.*?].*";
    private static final String ALL_SPACE_PATTERN = " +";

    private CorySqlBuilder() {
    }

    public static CoryInsertSqlBuilder createInsertBuilder(String table) {
        return new CoryInsertSqlBuilder(table);
    }

    public static CoryUpdateModelSqlBuilder createUpdateModelBuilder(String table) {
        return new CoryUpdateModelSqlBuilder(table);
    }

    public static CoryDeleteSqlBuilder createDeleteBuilder(String table, String whereSql, boolean logicDelete, Map<String, Object> ognlParamMap) {
        return new CoryDeleteSqlBuilder(table, whereSql, logicDelete, ognlParamMap);
    }

    public static CoryUpdateSqlBuilder createUpdateBuilder(String table, String columnSql, String whereSql, Map<String, Object> ognlParamMap) {
        return new CoryUpdateSqlBuilder(table, columnSql, whereSql, ognlParamMap);
    }

    public static CorySelectSqlBuilder createSelectBuilder(String table, String whereSql, boolean whereModel, boolean orderBy, boolean limit, String customSql, Map<String, Object> ognlParamMap, DataPermissionResult dataPermissionResult) {
        return new CorySelectSqlBuilder(table, whereSql, whereModel, orderBy, limit, customSql, ognlParamMap, dataPermissionResult);
    }

    private static String formatColumn(String column) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, column).toUpperCase();
    }

    private static CorySqlInfo parseColumnPart(String columnSql, Map<String, Object> ognlParamMap) {
        return CorySqlBuilder.parseParamSql(columnSql, ognlParamMap);
    }

    private static CorySqlInfo parseWherePart(String whereSql, Map<String, Object> ognlParamMap, boolean wrapAnd) {
        CorySqlInfo sqlInfo = CorySqlBuilder.parseParamSql(whereSql, ognlParamMap);
        if (StringUtils.isBlank((CharSequence)sqlInfo.getSql())) {
            return CorySqlInfo.builder().sql("").build();
        }
        if (wrapAnd) {
            String sql = " AND (" + sqlInfo.getSql() + ")";
            sqlInfo.setSql(sql);
        }
        return sqlInfo;
    }

    private static CorySqlInfo parseParamSql(String sql, Map<String, Object> ognlParamMap) {
        if (StringUtils.isBlank((CharSequence)sql)) {
            return CorySqlInfo.builder().sql("").build();
        }
        boolean hasParam = sql.matches(PARAM_PATTERN_FULL);
        boolean hasNullableParam = sql.matches(NULLABLE_PARAM_PATTERN_FULL);
        if (!hasParam && !hasNullableParam) {
            return CorySqlInfo.builder().sql(sql).build();
        }
        if (hasNullableParam) {
            Matcher nullableMatcher = NULLABLE_PARAM_PATTERN_REG.matcher(sql);
            while (nullableMatcher.find()) {
                String group = nullableMatcher.group(0);
                String subSql = group.trim().substring(3);
                subSql = subSql.substring(0, subSql.length() - 1);
                Matcher paramMatcher = PARAM_PATTERN_REG.matcher(subSql = subSql.trim());
                if (paramMatcher.find()) {
                    String paramGroup = paramMatcher.group(0);
                    String paramName = paramGroup.trim().substring(2);
                    paramName = paramName.substring(0, paramName.length() - 1);
                    Object value = ognlParamMap.get(paramName = paramName.trim());
                    sql = null != value ? sql.replace(group, subSql) : sql.replace(group, "");
                } else {
                    sql = sql.replace(group, subSql);
                }
                nullableMatcher = NULLABLE_PARAM_PATTERN_REG.matcher(sql);
            }
        }
        Matcher matcher = PARAM_PATTERN_REG.matcher(sql);
        ArrayList<Object> paramList = new ArrayList<Object>();
        while (matcher.find()) {
            String group = matcher.group(0);
            String paramName = group.trim().substring(2);
            paramName = paramName.substring(0, paramName.length() - 1);
            paramName = paramName.trim();
            Object value = ognlParamMap.get(paramName);
            sql = sql.replaceFirst(group.replace("{", "\\{").replace("}", "\\}"), CorySqlBuilder.parseQuestionAndAddParam(paramName, value, paramList));
            matcher = PARAM_PATTERN_REG.matcher(sql);
        }
        return CorySqlInfo.builder().sql(sql).params(paramList).build();
    }

    private static String parseQuestionAndAddParam(String paramName, Object paramValue, List<Object> paramList) {
        if (null == paramValue) {
            throw new CoryException(ErrorCode.DB_ERROR, new Object[]{paramName + "\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        if (paramValue.getClass().isArray()) {
            int len = Array.getLength(paramValue);
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(paramValue, i);
                paramList.add(item);
                list.add(QUESTION_MARK);
            }
            return "(" + StringUtils.join(list, (String)COMMA) + ")";
        }
        if (paramValue instanceof Collection) {
            Collection collection = (Collection)paramValue;
            ArrayList<String> list = new ArrayList<String>();
            for (Object item : collection) {
                paramList.add(item);
                list.add(QUESTION_MARK);
            }
            return "(" + StringUtils.join(list, (String)COMMA) + ")";
        }
        paramList.add(paramValue);
        return QUESTION_MARK;
    }

    private static String formatSql(String sql) {
        if (StringUtils.isBlank((CharSequence)sql)) {
            return sql;
        }
        sql = sql.replaceAll(COMMA, ", ");
        return StringUtils.join((Object[])sql.split(ALL_SPACE_PATTERN), (String)SPACE);
    }

    public static void main(String[] args) throws ParseException {
        String sql = "email = #{userName} or phone = #{userName}";
        Matcher matcher = PARAM_PATTERN_REG.matcher(sql);
        while (matcher.find()) {
            String group = matcher.group(0);
            sql = sql.replaceFirst(group.replace("{", "\\{").replace("}", "\\}"), QUESTION_MARK);
            System.out.println(sql);
            matcher = PARAM_PATTERN_REG.matcher(sql);
        }
        System.out.println("done 1");
        CorySqlInfo sqlInfo = CorySqlBuilder.createInsertBuilder("lm_device").column("id", 1).column("code", "TOOTH").column("name", "\u7259\u5957").column("typeCode", "Test").column("typeCodeName", "\u6d4b\u8bd5").column("spec_code", "tooth_spec").column("spec_code_name", "\u6d4b\u8bd5\u89c4\u683c").column("ext_1", true).column("ext2", new Object()).build();
        System.out.println("sql: " + sqlInfo.getSql());
        System.out.println("params: " + JSON.toJSONString(sqlInfo.getParams()));
        sqlInfo = CorySqlBuilder.createUpdateModelBuilder("lm_device").column("id", 1).column("code", "TOOTH").column("name", "\u7259\u5957").column("typeCode", "Test").column("typeCodeName", "\u6d4b\u8bd5").column("spec_code", "tooth_spec").column("spec_code_name", "\u6d4b\u8bd5\u89c4\u683c").column("ext_1", true).column("ext2", new Object()).build();
        System.out.println("sql: " + sqlInfo.getSql());
        System.out.println("params: " + JSON.toJSONString(sqlInfo.getParams()));
        List<String> codeList = Arrays.asList("123", "456");
        Map params = MapBuilder.create(String.class, Object.class).put((Object)"codeList", codeList).put((Object)"name", (Object)"\u5f20\u4e09").put((Object)"typeCode", (Object)"789").put((Object)"foreignCode", (Object)"fff").put((Object)PARAM_PAGE_START, (Object)20).put((Object)PARAM_PAGE_SIZE, (Object)10).put((Object)PARAM_SORT, (Object)"code desc").build();
        sqlInfo = CorySqlBuilder.createDeleteBuilder("lm_device", "code in #{codeList} #![and name like #{name}] and name not like #{name} and not exists (select 1 from xx where code = #{foreignCode}) and type_code = #{typeCode}", true, params).build();
        System.out.println("sql: " + sqlInfo.getSql());
        System.out.println("params: " + JSON.toJSONString(sqlInfo.getParams()));
        sqlInfo = CorySqlBuilder.createUpdateBuilder("lm_device", "name = #{name}, modifier = 0, modify_time = now(), type_code = #{typeCode}", "code in #{codeList}", params).build();
        System.out.println("sql: " + sqlInfo.getSql());
        System.out.println("params: " + JSON.toJSONString(sqlInfo.getParams()));
        params.remove("name");
        sqlInfo = CorySqlBuilder.createSelectBuilder("lm_device", "code in #{codeList} #![and name like #{name}] and type_code = #{typeCode}", true, true, true, null, params, null).column("code", "123").column("type", "DEVICE").column("age", 19).buildDataSql();
        System.out.println("sql: " + sqlInfo.getSql());
        System.out.println("params: " + JSON.toJSONString(sqlInfo.getParams()));
        params.remove("name");
        sqlInfo = CorySqlBuilder.createSelectBuilder("lm_device", "code in #{codeList} #![and name like #{name}] and type_code = #{typeCode}", true, true, true, null, params, null).column("code", "123").column("type", "DEVICE").column("age", 19).buildCountSql();
        System.out.println("sql: " + sqlInfo.getSql());
        System.out.println("params: " + JSON.toJSONString(sqlInfo.getParams()));
    }

    public static class CorySelectSqlBuilder {
        protected String table;
        protected String whereSql;
        protected boolean whereModel;
        protected boolean orderBy;
        protected boolean limit;
        protected String customSql;
        protected Map<String, Object> ognlParamMap = new HashMap<String, Object>();
        protected DataPermissionResult dataPermissionResult;
        protected List<CorySqlColumnValue> columnValueList = new ArrayList<CorySqlColumnValue>();

        CorySelectSqlBuilder(String table, String whereSql, boolean whereModel, boolean orderBy, boolean limit, String customSql, Map<String, Object> ognlParamMap, DataPermissionResult dataPermissionResult) {
            this.table = table;
            this.whereSql = whereSql;
            this.whereModel = whereModel;
            this.orderBy = orderBy;
            this.limit = limit;
            this.customSql = customSql;
            this.ognlParamMap = ognlParamMap;
            this.dataPermissionResult = dataPermissionResult;
        }

        public CorySelectSqlBuilder column(String column, Object value) {
            AssertUtils.hasText((String)column, (String)"\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a", (ErrorCode)ErrorCode.DB_ERROR);
            this.columnValueList.add(CorySqlColumnValue.builder().column(CorySqlBuilder.formatColumn(column)).param(value).build());
            return this;
        }

        private CorySqlInfo buildSelectWherePart() {
            CorySqlInfo wherePart = CorySqlBuilder.parseWherePart(this.whereSql, this.ognlParamMap, true);
            if (null != this.dataPermissionResult && DataPermissionStrategy.DENY.equals((Object)this.dataPermissionResult.getStrategy())) {
                return CorySqlInfo.builder().selectDenied(true).build();
            }
            List<Object> params = wherePart.getParams();
            StringBuilder whereSql = new StringBuilder(wherePart.getSql());
            if (null != this.dataPermissionResult && DataPermissionStrategy.FILTER.equals((Object)this.dataPermissionResult.getStrategy())) {
                whereSql.append("AND (" + this.dataPermissionResult.getFilterSql() + ")");
            }
            if (this.whereModel) {
                this.columnValueList.forEach(cv -> {
                    if (cv.getColumn().equalsIgnoreCase(CorySqlBuilder.CREATOR) || cv.getColumn().equalsIgnoreCase(CorySqlBuilder.MODIFIER) || cv.getColumn().equalsIgnoreCase(CorySqlBuilder.CREATE_TIME) || cv.getColumn().equalsIgnoreCase(CorySqlBuilder.MODIFY_TIME) || cv.getColumn().equalsIgnoreCase(CorySqlBuilder.IS_DELETED)) {
                        return;
                    }
                    whereSql.append(" AND " + cv.getColumn() + CorySqlBuilder.SPACE + CorySqlBuilder.EQUAL + CorySqlBuilder.SPACE + CorySqlBuilder.QUESTION_MARK);
                    params.add(cv.getParam());
                });
            }
            if (MapUtils.isNotEmpty(this.ognlParamMap)) {
                this.ognlParamMap.entrySet().forEach(entry -> {
                    Object value = entry.getValue();
                    if (!(value instanceof BaseModel)) {
                        return;
                    }
                    BaseModel model = (BaseModel)value;
                    if (MapUtils.isEmpty((Map)model.getFilterFieldMap())) {
                        return;
                    }
                    model.getFilterFieldMap().entrySet().forEach(filter -> {
                        if (null == filter.getValue()) {
                            return;
                        }
                        String key = (String)filter.getKey();
                        if (key.endsWith("StartInclusive")) {
                            String columnField = key.substring(0, key.length() - "StartInclusive".length());
                            String columnName = CoryModelUtil.buildColumnName(columnField);
                            whereSql.append(" AND " + columnName + " >= " + CorySqlBuilder.QUESTION_MARK);
                            params.add(filter.getValue());
                        } else if (key.endsWith("StartExclusive")) {
                            String columnField = key.substring(0, key.length() - "StartExclusive".length());
                            String columnName = CoryModelUtil.buildColumnName(columnField);
                            whereSql.append(" AND " + columnName + " > " + CorySqlBuilder.QUESTION_MARK);
                            params.add(filter.getValue());
                        } else if (key.endsWith("EndInclusive")) {
                            String columnField = key.substring(0, key.length() - "EndInclusive".length());
                            String columnName = CoryModelUtil.buildColumnName(columnField);
                            whereSql.append(" AND " + columnName + " <= " + CorySqlBuilder.QUESTION_MARK);
                            params.add(filter.getValue());
                        } else if (key.endsWith("EndExclusive")) {
                            String columnField = key.substring(0, key.length() - "EndExclusive".length());
                            String columnName = CoryModelUtil.buildColumnName(columnField);
                            whereSql.append(" AND " + columnName + " < " + CorySqlBuilder.QUESTION_MARK);
                            params.add(filter.getValue());
                        } else if (key.endsWith("In1") || key.endsWith("NotIn2")) {
                            boolean isNotIn = key.endsWith("NotIn2");
                            String columnField = key.substring(0, key.length() - (isNotIn ? "NotIn2".length() : "In1".length()));
                            String columnName = CoryModelUtil.buildColumnName(columnField);
                            List list = (List)filter.getValue();
                            StringBuilder inSql = new StringBuilder("(");
                            for (int i = 0; i < list.size(); ++i) {
                                inSql.append(CorySqlBuilder.QUESTION_MARK);
                                inSql.append(CorySqlBuilder.COMMA);
                                params.add(list.get(i));
                            }
                            inSql.deleteCharAt(inSql.length() - 1);
                            inSql.append(")");
                            whereSql.append(" AND " + columnName + (isNotIn ? " not in " : " in ") + inSql);
                        } else if (key.endsWith("LikeLeft1") || key.endsWith("LikeRight1") || key.endsWith("LikeBoth1") || key.endsWith("NotLikeLeft2") || key.endsWith("NotLikeRight2") || key.endsWith("NotLikeBoth2")) {
                            boolean onlyLikeLeft = key.endsWith("LikeLeft1");
                            boolean onlyLikeRight = key.endsWith("LikeRight1");
                            boolean bothLike = key.endsWith("LikeBoth1");
                            boolean onlyNotLikeLeft = key.endsWith("NotLikeLeft2");
                            boolean onlyNotLikeRight = key.endsWith("NotLikeRight2");
                            boolean bothNotLike = key.endsWith("NotLikeBoth2");
                            String columnField = onlyNotLikeLeft ? key.substring(0, key.length() - "NotLikeLeft2".length()) : (onlyNotLikeRight ? key.substring(0, key.length() - "NotLikeRight2".length()) : (bothNotLike ? key.substring(0, key.length() - "NotLikeBoth2".length()) : (onlyLikeLeft ? key.substring(0, key.length() - "LikeLeft1".length()) : (onlyLikeRight ? key.substring(0, key.length() - "LikeRight1".length()) : key.substring(0, key.length() - "LikeBoth1".length())))));
                            String columnName = CoryModelUtil.buildColumnName(columnField);
                            whereSql.append(" AND " + columnName);
                            if (onlyNotLikeLeft || onlyNotLikeRight || bothNotLike) {
                                whereSql.append(" not");
                            }
                            whereSql.append(" like concat(");
                            if (onlyLikeLeft || onlyNotLikeLeft || bothLike || bothNotLike) {
                                whereSql.append("'%', ");
                            }
                            whereSql.append(CorySqlBuilder.QUESTION_MARK);
                            if (onlyLikeRight || onlyNotLikeRight || bothLike || bothNotLike) {
                                whereSql.append(", '%'");
                            }
                            whereSql.append(" ) ");
                            params.add(filter.getValue());
                        } else if (key.endsWith("NotEq")) {
                            String columnField = key.substring(0, key.length() - "NotEq".length());
                            String columnName = CoryModelUtil.buildColumnName(columnField);
                            whereSql.append(" AND " + columnName + " <> " + CorySqlBuilder.QUESTION_MARK);
                            params.add(filter.getValue());
                        } else if (key.endsWith("IsNull")) {
                            String columnField = key.substring(0, key.length() - "IsNull".length());
                            String columnName = CoryModelUtil.buildColumnName(columnField);
                            whereSql.append(" AND " + columnName + " is null");
                        } else if (key.endsWith("NotNull")) {
                            String columnField = key.substring(0, key.length() - "NotNull".length());
                            String columnName = CoryModelUtil.buildColumnName(columnField);
                            whereSql.append(" AND " + columnName + " is not null");
                        } else if (key.equals("Custom")) {
                            whereSql.append(" AND (" + filter.getValue() + ")");
                        }
                    });
                });
            }
            return CorySqlInfo.builder().sql(whereSql.toString()).params(params).build();
        }

        public CorySqlInfo buildDataSql() {
            String sql;
            if (StringUtils.isNotBlank((CharSequence)this.customSql)) {
                CorySqlInfo wherePart = CorySqlBuilder.parseWherePart(this.customSql, this.ognlParamMap, false);
                return CorySqlInfo.builder().sql(CorySqlBuilder.formatSql(wherePart.getSql())).params(wherePart.getParams()).build();
            }
            CorySqlInfo wherePart = this.buildSelectWherePart();
            if (wherePart.selectDenied.booleanValue()) {
                return wherePart;
            }
            this.checkForLimit(this.limit, this.ognlParamMap);
            if (this.needOptForLimit(this.limit, this.ognlParamMap)) {
                String orderByPart = "";
                if (this.orderBy) {
                    String sort = (String)this.ognlParamMap.get(CorySqlBuilder.PARAM_SORT);
                    if (StringUtils.isBlank((CharSequence)sort)) {
                        sort = "MODIFY_TIME DESC";
                    }
                    orderByPart = " ORDER BY " + sort;
                }
                Integer pageStart = (Integer)this.ognlParamMap.get(CorySqlBuilder.PARAM_PAGE_START);
                Integer pageSize = (Integer)this.ognlParamMap.get(CorySqlBuilder.PARAM_PAGE_SIZE);
                sql = String.format("SELECT a.* from %s a right join (select id from %s where is_deleted = 0 %s %s limit %s, %s) b on a.id = b.id %s", this.table, this.table, wherePart.getSql(), orderByPart, pageStart, pageSize, orderByPart);
            } else {
                sql = String.format("SELECT * FROM %s WHERE IS_DELETED = 0 %s", this.table, wherePart.getSql());
                if (this.orderBy) {
                    String sort = (String)this.ognlParamMap.get(CorySqlBuilder.PARAM_SORT);
                    if (StringUtils.isBlank((CharSequence)sort)) {
                        sort = "MODIFY_TIME DESC";
                    }
                    sql = sql + " ORDER BY " + sort;
                }
                if (this.limit) {
                    Integer pageStart = (Integer)this.ognlParamMap.get(CorySqlBuilder.PARAM_PAGE_START);
                    Integer pageSize = (Integer)this.ognlParamMap.get(CorySqlBuilder.PARAM_PAGE_SIZE);
                    sql = sql + String.format(" LIMIT %s, %s", pageStart, pageSize);
                }
            }
            return CorySqlInfo.builder().sql(CorySqlBuilder.formatSql(sql)).params(wherePart.getParams()).build();
        }

        private boolean needOptForLimit(boolean limit, Map<String, Object> ognlParamMap) {
            if (!limit) {
                return false;
            }
            Integer pageStart = (Integer)ognlParamMap.get(CorySqlBuilder.PARAM_PAGE_START);
            return pageStart > 10000;
        }

        private void checkForLimit(boolean limit, Map<String, Object> ognlParamMap) {
            if (!limit) {
                return;
            }
            Integer pageStart = (Integer)ognlParamMap.get(CorySqlBuilder.PARAM_PAGE_START);
            Integer pageSize = (Integer)ognlParamMap.get(CorySqlBuilder.PARAM_PAGE_SIZE);
            AssertUtils.notNull((Object)pageStart, (String)"limit\u9700\u8981pageStart\u53c2\u6570\uff0c\u8bf7\u6dfb\u52a0", (ErrorCode)ErrorCode.DB_ERROR);
            AssertUtils.notNull((Object)pageSize, (String)"limit\u9700\u8981pageSize\u53c2\u6570\uff0c\u8bf7\u6dfb\u52a0", (ErrorCode)ErrorCode.DB_ERROR);
        }

        public CorySqlInfo buildCountSql() {
            CorySqlInfo wherePart = this.buildSelectWherePart();
            if (wherePart.selectDenied.booleanValue()) {
                return wherePart;
            }
            String sql = String.format("SELECT COUNT(*) FROM %s WHERE IS_DELETED = 0 %s", this.table, wherePart.getSql());
            return CorySqlInfo.builder().sql(CorySqlBuilder.formatSql(sql)).params(wherePart.getParams()).build();
        }
    }

    public static class CoryUpdateSqlBuilder {
        protected String table;
        protected String columnSql;
        protected String whereSql;
        protected Map<String, Object> ognlParamMap = new HashMap<String, Object>();

        CoryUpdateSqlBuilder(String table, String columnSql, String whereSql, Map<String, Object> ognlParamMap) {
            this.table = table;
            this.columnSql = columnSql;
            this.whereSql = whereSql;
            this.ognlParamMap = ognlParamMap;
        }

        public CorySqlInfo build() {
            CorySqlInfo columnPart = CorySqlBuilder.parseColumnPart(this.columnSql, this.ognlParamMap);
            CorySqlInfo wherePart = CorySqlBuilder.parseWherePart(this.whereSql, this.ognlParamMap, true);
            ArrayList<Object> params = new ArrayList<Object>();
            if (CollectionUtils.isNotEmpty(columnPart.getParams())) {
                params.addAll(columnPart.getParams());
            }
            if (CollectionUtils.isNotEmpty(wherePart.getParams())) {
                params.addAll(wherePart.getParams());
            }
            String sql = String.format("UPDATE %s SET %s WHERE IS_DELETED = 0 %s", this.table, "MODIFY_TIME = now(), " + columnPart.getSql(), wherePart.getSql());
            return CorySqlInfo.builder().sql(CorySqlBuilder.formatSql(sql)).params(params).build();
        }
    }

    public static class CoryDeleteSqlBuilder
    extends CoryUpdateSqlBuilder {
        private boolean logicDelete;

        CoryDeleteSqlBuilder(String table, String whereSql, boolean logicDelete, Map<String, Object> ognlParamMap) {
            super(table, null, whereSql, ognlParamMap);
            this.logicDelete = logicDelete;
        }

        @Override
        public CorySqlInfo build() {
            String sql;
            CorySqlInfo wherePart;
            if (this.logicDelete) {
                wherePart = CorySqlBuilder.parseWherePart(this.whereSql, this.ognlParamMap, true);
                sql = String.format("UPDATE %s SET IS_DELETED = 1, MODIFY_TIME = now() WHERE IS_DELETED = 0 %s", this.table, wherePart.getSql());
            } else {
                wherePart = CorySqlBuilder.parseWherePart(this.whereSql, this.ognlParamMap, false);
                sql = String.format("DELETE FROM %s WHERE %s", this.table, wherePart.getSql());
            }
            return CorySqlInfo.builder().sql(CorySqlBuilder.formatSql(sql)).params(wherePart.getParams()).build();
        }
    }

    public static class CoryUpdateModelSqlBuilder {
        private String table;
        private List<CorySqlColumnValue> columnValueList = new ArrayList<CorySqlColumnValue>();

        CoryUpdateModelSqlBuilder(String table) {
            this.table = table;
        }

        public CoryUpdateModelSqlBuilder column(String column, Object value) {
            AssertUtils.hasText((String)column, (String)"\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a", (ErrorCode)ErrorCode.DB_ERROR);
            this.columnValueList.add(CorySqlColumnValue.builder().column(CorySqlBuilder.formatColumn(column)).param(value).build());
            return this;
        }

        public CorySqlInfo build() {
            ArrayList columnList = new ArrayList();
            ArrayList<Object> paramList = new ArrayList<Object>();
            this.columnValueList.forEach(cv -> {
                if (cv.getColumn().equalsIgnoreCase(CorySqlBuilder.ID)) {
                    return;
                }
                columnList.add(cv.getColumn() + CorySqlBuilder.SPACE + CorySqlBuilder.EQUAL + CorySqlBuilder.SPACE + CorySqlBuilder.QUESTION_MARK);
                paramList.add(cv.getParam());
            });
            Object id = this.columnValueList.stream().filter(cv -> cv.getColumn().equalsIgnoreCase(CorySqlBuilder.ID)).findFirst().get().getParam();
            paramList.add(id);
            String sql = String.format("UPDATE %s SET %s where ID = ?", this.table, StringUtils.join(columnList, (String)CorySqlBuilder.COMMA), id);
            return CorySqlInfo.builder().sql(CorySqlBuilder.formatSql(sql)).params(paramList).build();
        }
    }

    public static class CoryInsertSqlBuilder {
        private String table;
        private List<CorySqlColumnValue> columnValueList = new ArrayList<CorySqlColumnValue>();

        CoryInsertSqlBuilder(String table) {
            this.table = table;
        }

        public CoryInsertSqlBuilder column(String column, Object value) {
            AssertUtils.hasText((String)column, (String)"\u5b57\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a", (ErrorCode)ErrorCode.DB_ERROR);
            this.columnValueList.add(CorySqlColumnValue.builder().column(CorySqlBuilder.formatColumn(column)).param(value).build());
            return this;
        }

        public CorySqlInfo build() {
            ArrayList columnList = new ArrayList();
            ArrayList paramPlaceholderList = new ArrayList();
            ArrayList<Object> paramList = new ArrayList<Object>();
            this.columnValueList.forEach(cv -> {
                columnList.add(cv.getColumn());
                paramPlaceholderList.add(CorySqlBuilder.QUESTION_MARK);
                paramList.add(cv.getParam());
            });
            String sql = String.format("INSERT INTO %s (%s) VALUES (%s)", this.table, StringUtils.join(columnList, (String)CorySqlBuilder.COMMA), StringUtils.join(paramPlaceholderList, (String)CorySqlBuilder.COMMA));
            return CorySqlInfo.builder().sql(CorySqlBuilder.formatSql(sql)).params(paramList).build();
        }
    }

    private static class CorySqlColumnValue
    implements Serializable {
        private String column;
        private Object param;

        CorySqlColumnValue(String column, Object param) {
            this.column = column;
            this.param = param;
        }

        public static CorySqlColumnValueBuilder builder() {
            return new CorySqlColumnValueBuilder();
        }

        public String getColumn() {
            return this.column;
        }

        public Object getParam() {
            return this.param;
        }

        public void setColumn(String column) {
            this.column = column;
        }

        public void setParam(Object param) {
            this.param = param;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CorySqlColumnValue)) {
                return false;
            }
            CorySqlColumnValue other = (CorySqlColumnValue)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$column = this.getColumn();
            String other$column = other.getColumn();
            if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
                return false;
            }
            Object this$param = this.getParam();
            Object other$param = other.getParam();
            return !(this$param == null ? other$param != null : !this$param.equals(other$param));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CorySqlColumnValue;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : $column.hashCode());
            Object $param = this.getParam();
            result = result * 59 + ($param == null ? 43 : $param.hashCode());
            return result;
        }

        public String toString() {
            return "CorySqlBuilder.CorySqlColumnValue(column=" + this.getColumn() + ", param=" + this.getParam() + ")";
        }

        public static class CorySqlColumnValueBuilder {
            private String column;
            private Object param;

            CorySqlColumnValueBuilder() {
            }

            public CorySqlColumnValueBuilder column(String column) {
                this.column = column;
                return this;
            }

            public CorySqlColumnValueBuilder param(Object param) {
                this.param = param;
                return this;
            }

            public CorySqlColumnValue build() {
                return new CorySqlColumnValue(this.column, this.param);
            }

            public String toString() {
                return "CorySqlBuilder.CorySqlColumnValue.CorySqlColumnValueBuilder(column=" + this.column + ", param=" + this.param + ")";
            }
        }
    }

    public static class CorySqlInfo
    implements Serializable {
        private String sql;
        private List<Object> params;
        private Boolean selectDenied;

        public String toString() {
            return "sql: " + this.sql + ", params: " + JSON.toJSONString(this.params);
        }

        private static List<Object> $default$params() {
            return new ArrayList<Object>();
        }

        private static Boolean $default$selectDenied() {
            return false;
        }

        public static CorySqlInfoBuilder builder() {
            return new CorySqlInfoBuilder();
        }

        public String getSql() {
            return this.sql;
        }

        public List<Object> getParams() {
            return this.params;
        }

        public Boolean getSelectDenied() {
            return this.selectDenied;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public void setParams(List<Object> params) {
            this.params = params;
        }

        public void setSelectDenied(Boolean selectDenied) {
            this.selectDenied = selectDenied;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CorySqlInfo)) {
                return false;
            }
            CorySqlInfo other = (CorySqlInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$selectDenied = this.getSelectDenied();
            Boolean other$selectDenied = other.getSelectDenied();
            if (this$selectDenied == null ? other$selectDenied != null : !((Object)this$selectDenied).equals(other$selectDenied)) {
                return false;
            }
            String this$sql = this.getSql();
            String other$sql = other.getSql();
            if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
                return false;
            }
            List<Object> this$params = this.getParams();
            List<Object> other$params = other.getParams();
            return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CorySqlInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $selectDenied = this.getSelectDenied();
            result = result * 59 + ($selectDenied == null ? 43 : ((Object)$selectDenied).hashCode());
            String $sql = this.getSql();
            result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
            List<Object> $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
            return result;
        }

        public CorySqlInfo(String sql, List<Object> params, Boolean selectDenied) {
            this.sql = sql;
            this.params = params;
            this.selectDenied = selectDenied;
        }

        public CorySqlInfo() {
            this.params = CorySqlInfo.$default$params();
            this.selectDenied = CorySqlInfo.$default$selectDenied();
        }

        public static class CorySqlInfoBuilder {
            private String sql;
            private boolean params$set;
            private List<Object> params$value;
            private boolean selectDenied$set;
            private Boolean selectDenied$value;

            CorySqlInfoBuilder() {
            }

            public CorySqlInfoBuilder sql(String sql) {
                this.sql = sql;
                return this;
            }

            public CorySqlInfoBuilder params(List<Object> params) {
                this.params$value = params;
                this.params$set = true;
                return this;
            }

            public CorySqlInfoBuilder selectDenied(Boolean selectDenied) {
                this.selectDenied$value = selectDenied;
                this.selectDenied$set = true;
                return this;
            }

            public CorySqlInfo build() {
                List params$value = this.params$value;
                if (!this.params$set) {
                    params$value = CorySqlInfo.$default$params();
                }
                Boolean selectDenied$value = this.selectDenied$value;
                if (!this.selectDenied$set) {
                    selectDenied$value = CorySqlInfo.$default$selectDenied();
                }
                return new CorySqlInfo(this.sql, params$value, selectDenied$value);
            }

            public String toString() {
                return "CorySqlBuilder.CorySqlInfo.CorySqlInfoBuilder(sql=" + this.sql + ", params$value=" + this.params$value + ", selectDenied$value=" + this.selectDenied$value + ")";
            }
        }
    }
}

