/*
 * Decompiled with CFR 0.152.
 */
package com.cory.db.jdbc;

import com.alibaba.fastjson.JSON;
import com.cory.constant.ErrorCode;
import com.cory.db.jdbc.CoryDb;
import com.cory.db.jdbc.CorySqlBuilder;
import com.cory.exception.CoryException;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class RealCoryDb
implements CoryDb {
    private JdbcTemplate jdbcTemplate;

    public RealCoryDb(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public int insert(CorySqlBuilder.CorySqlInfo sqlInfo) {
        PreparedStatementCreator creator = conn -> {
            PreparedStatement pstmt = conn.prepareStatement(sqlInfo.getSql(), 1);
            Object[] params = this.buildParams(sqlInfo);
            if (null != params && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    pstmt.setObject(i + 1, params[i]);
                }
            }
            return pstmt;
        };
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        int row = this.jdbcTemplate.update(creator, (KeyHolder)keyHolder);
        if (row > 0) {
            return ((BigInteger)keyHolder.getKeyAs(BigInteger.class)).intValue();
        }
        throw new CoryException(ErrorCode.DB_ERROR, new Object[]{"\u63d2\u5165\u5931\u8d25(\u5f71\u54cd\u884c\u6570\uff1a" + row + ")\uff0csqlInfo: " + JSON.toJSONString((Object)sqlInfo)});
    }

    @Override
    public int delete(CorySqlBuilder.CorySqlInfo sqlInfo) {
        return this.jdbcTemplate.update(sqlInfo.getSql(), this.buildParams(sqlInfo));
    }

    @Override
    public int update(CorySqlBuilder.CorySqlInfo sqlInfo) {
        return this.jdbcTemplate.update(sqlInfo.getSql(), this.buildParams(sqlInfo));
    }

    @Override
    public List<Map<String, Object>> select(CorySqlBuilder.CorySqlInfo sqlInfo) {
        return this.jdbcTemplate.queryForList(sqlInfo.getSql(), this.buildParams(sqlInfo));
    }

    @Override
    public int selectCount(CorySqlBuilder.CorySqlInfo sqlInfo) {
        return (Integer)this.jdbcTemplate.queryForObject(sqlInfo.getSql(), Integer.class, this.buildParams(sqlInfo));
    }

    private Object[] buildParams(CorySqlBuilder.CorySqlInfo sqlInfo) {
        List<Object> params = sqlInfo.getParams();
        return null == params ? new Object[]{} : params.toArray(new Object[params.size()]);
    }

    @Override
    public void executeSql(String sql) {
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public int update(String sql) {
        return this.jdbcTemplate.update(sql);
    }

    @Override
    public List<Map<String, Object>> query(String sql) {
        return this.jdbcTemplate.queryForList(sql);
    }
}

