/*
 * Decompiled with CFR 0.152.
 */
package com.cory.db.jdbc;

import com.cory.constant.ErrorCode;
import com.cory.db.jdbc.Column;
import com.cory.exception.CoryException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class Table {
    private String name;
    private String comment;
    private List<Column> columnList;
    private Map<String, Column> columnMap;

    public boolean equals(Object o) {
        if (!(o instanceof Table)) {
            return false;
        }
        Table t = (Table)o;
        if (!StringUtils.equals((CharSequence)this.name.toUpperCase(), (CharSequence)t.name.toUpperCase())) {
            return false;
        }
        if (CollectionUtils.isEmpty(this.columnList)) {
            if (CollectionUtils.isNotEmpty(t.columnList)) {
                return false;
            }
        } else {
            if (CollectionUtils.isEmpty(t.columnList)) {
                return false;
            }
            if (this.columnList.size() != t.columnList.size()) {
                return false;
            }
            for (Column column : this.columnList) {
                Column tc = t.columnMap.get(column.getName());
                if (null != tc && column.equals(tc)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.name.hashCode() + this.columnList.hashCode() * 31;
    }

    public List<Column> differentColumns(Table table, COLUMN_TYPE type) {
        if (type.equals((Object)COLUMN_TYPE.ADD)) {
            if (CollectionUtils.isEmpty(table.getColumnList())) {
                return this.columnList;
            }
            if (CollectionUtils.isEmpty(this.columnList)) {
                return new ArrayList<Column>();
            }
            return this.columnList.stream().filter(c -> null == table.getColumnMap().get(c.getName())).collect(Collectors.toList());
        }
        if (type.equals((Object)COLUMN_TYPE.DELETE)) {
            if (CollectionUtils.isEmpty(this.columnList)) {
                return table.getColumnList();
            }
            if (CollectionUtils.isEmpty(table.getColumnList())) {
                return new ArrayList<Column>();
            }
            return table.getColumnList().stream().filter(c -> null == this.columnMap.get(c.getName())).collect(Collectors.toList());
        }
        if (type.equals((Object)COLUMN_TYPE.MODIFY)) {
            if (CollectionUtils.isEmpty(this.columnList) || CollectionUtils.isEmpty(table.getColumnList())) {
                return new ArrayList<Column>();
            }
            return this.columnList.stream().filter(c -> null != table.getColumnMap().get(c.getName()) && !c.equals(table.getColumnMap().get(c.getName()))).collect(Collectors.toList());
        }
        throw new CoryException(ErrorCode.DB_ERROR, new Object[]{"un supported column type(COLUMN_TYPE)"});
    }

    public static TableBuilder builder() {
        return new TableBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public List<Column> getColumnList() {
        return this.columnList;
    }

    public Map<String, Column> getColumnMap() {
        return this.columnMap;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setColumnList(List<Column> columnList) {
        this.columnList = columnList;
    }

    public void setColumnMap(Map<String, Column> columnMap) {
        this.columnMap = columnMap;
    }

    public String toString() {
        return "Table(name=" + this.getName() + ", comment=" + this.getComment() + ", columnList=" + this.getColumnList() + ", columnMap=" + this.getColumnMap() + ")";
    }

    public Table() {
    }

    public Table(String name, String comment, List<Column> columnList, Map<String, Column> columnMap) {
        this.name = name;
        this.comment = comment;
        this.columnList = columnList;
        this.columnMap = columnMap;
    }

    public static class TableBuilder {
        private String name;
        private String comment;
        private List<Column> columnList;
        private Map<String, Column> columnMap;

        TableBuilder() {
        }

        public TableBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TableBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public TableBuilder columnList(List<Column> columnList) {
            this.columnList = columnList;
            return this;
        }

        public TableBuilder columnMap(Map<String, Column> columnMap) {
            this.columnMap = columnMap;
            return this;
        }

        public Table build() {
            return new Table(this.name, this.comment, this.columnList, this.columnMap);
        }

        public String toString() {
            return "Table.TableBuilder(name=" + this.name + ", comment=" + this.comment + ", columnList=" + this.columnList + ", columnMap=" + this.columnMap + ")";
        }
    }

    public static enum COLUMN_TYPE {
        ADD,
        MODIFY,
        DELETE;

    }
}

