/*
 * Decompiled with CFR 0.152.
 */
package com.cory.db.jdbc.mapper;

import com.cory.constant.ErrorCode;
import com.cory.context.CorySystemContext;
import com.cory.db.jdbc.mapper.SingleResultMapper;
import com.cory.enums.CoryEnum;
import com.cory.exception.CoryException;
import com.cory.model.BaseModel;
import com.cory.util.ClassUtil;
import com.cory.util.DateUtils;
import com.cory.util.MapBuilder;
import com.google.common.base.CaseFormat;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanMapper
extends SingleResultMapper {
    private static final Logger log = LoggerFactory.getLogger(BeanMapper.class);
    private static final String TEXT = "Text";
    private static final BeanUtilsBean UTIL = BeanMapper.newBeanUtilsBean();

    @Override
    protected Object doMap(Map<String, Object> map, Class<?> returnType) {
        try {
            MapBuilder builder = MapBuilder.create(String.class, Object.class);
            if (MapUtils.isNotEmpty(map)) {
                map.entrySet().forEach(entry -> builder.put((Object)CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, (String)entry.getKey()), entry.getValue()));
            }
            Object obj = returnType.newInstance();
            UTIL.populate(obj, builder.build());
            this.processRenderName(obj, returnType);
            return obj;
        }
        catch (Exception e) {
            log.error("map to bean error", (Throwable)e);
            throw new CoryException(ErrorCode.DB_ERROR, new Object[]{"map to bean error" + e.getMessage()});
        }
    }

    private void processRenderName(Object obj, Class<?> cls) {
        if (!(obj instanceof BaseModel)) {
            return;
        }
        BaseModel baseModel = (BaseModel)obj;
        baseModel.getRenderFieldMap().put("createTimeText", DateUtils.formatFull((Date)baseModel.getCreateTime()));
        baseModel.getRenderFieldMap().put("modifyTimeText", DateUtils.formatFull((Date)baseModel.getModifyTime()));
        baseModel.getRenderFieldMap().put("isDeletedText", null != baseModel.getIsDeleted() && baseModel.getIsDeleted() != false ? "\u5df2\u5220\u9664" : "\u672a\u5220\u9664");
        Field[] fields = obj.getClass().getDeclaredFields();
        if (null == fields || fields.length == 0) {
            return;
        }
        Map fieldMap = ClassUtil.fetchProperties((Object)obj, cls, null);
        for (Field field : fields) {
            String renderName;
            String name = field.getName();
            Object value = fieldMap.get(name);
            if (null == value) continue;
            com.cory.db.annotations.Field fieldAnno = field.getAnnotation(com.cory.db.annotations.Field.class);
            String string = renderName = null == fieldAnno || StringUtils.isBlank((CharSequence)fieldAnno.renderName()) ? name + TEXT : fieldAnno.renderName();
            if (field.getType().equals(Boolean.class)) {
                baseModel.getRenderFieldMap().put(renderName, (Boolean)value != false ? "\u662f" : "\u5426");
                continue;
            }
            if (CoryEnum.class.isAssignableFrom(field.getType())) {
                baseModel.getRenderFieldMap().put(renderName, ((CoryEnum)value).text());
                continue;
            }
            if (!Date.class.isAssignableFrom(field.getType())) continue;
            baseModel.getRenderFieldMap().put(renderName, DateUtils.formatFull((Date)((Date)value)));
        }
    }

    private static BeanUtilsBean newBeanUtilsBean() {
        ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
        convertUtilsBean.deregister(Date.class);
        convertUtilsBean.deregister(Timestamp.class);
        DateTimeConverter converter = new DateTimeConverter();
        convertUtilsBean.register((Converter)converter, Date.class);
        convertUtilsBean.register((Converter)converter, Timestamp.class);
        CoryEnumConverter enumConverter = new CoryEnumConverter();
        Set enumSet = CorySystemContext.get().getCoryEnumSet();
        if (CollectionUtils.isNotEmpty((Collection)enumSet)) {
            enumSet.forEach(cls -> {
                convertUtilsBean.deregister(cls);
                convertUtilsBean.register((Converter)enumConverter, cls);
            });
        }
        return new BeanUtilsBean(convertUtilsBean, new PropertyUtilsBean());
    }

    private static class CoryEnumConverter
    implements Converter {
        private CoryEnumConverter() {
        }

        public <T> T convert(Class<T> type, Object value) {
            if (null == value || !(value instanceof String)) {
                return (T)value;
            }
            String str = (String)value;
            Class<T> cls = type;
            return Enum.valueOf(cls, str);
        }
    }

    private static class DateTimeConverter
    implements Converter {
        private DateTimeConverter() {
        }

        public <T> T convert(Class<T> type, Object value) {
            if (null == value || !(value instanceof String)) {
                return (T)value;
            }
            String str = (String)value;
            try {
                if (type.equals(Date.class)) {
                    return (T)DateUtils.parseDate((String)str);
                }
                if (type.equals(Timestamp.class)) {
                    return (T)new Timestamp(DateUtils.parseDate((String)str).getTime());
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return (T)value;
        }
    }
}

