/*
 * Decompiled with CFR 0.152.
 */
package com.cory.db.jdbc.mapper;

import com.cory.db.jdbc.mapper.BeanMapper;
import com.cory.db.jdbc.mapper.DateMapper;
import com.cory.db.jdbc.mapper.ListMapper;
import com.cory.db.jdbc.mapper.MapListMapper;
import com.cory.db.jdbc.mapper.ResultMapper;
import com.cory.db.jdbc.mapper.SimpleMapper;
import com.cory.db.jdbc.mapper.TimestampMapper;
import com.cory.model.BaseModel;
import com.cory.util.ClassUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class ResultMapperFactory {
    public static Pair<ResultMapper, Class<?>> parseMapper(Class<?> returnType, Class<?> modelClass, Class selectReturnType) {
        if (ResultMapperFactory.isMapListType(returnType)) {
            return Pair.of((Object)new MapListMapper(), returnType);
        }
        if (returnType.equals(List.class)) {
            Class cls = ClassUtil.parseGenericType(returnType);
            if (null == cls || cls.equals(Object.class)) {
                cls = null != selectReturnType && !Void.class.equals((Object)selectReturnType) ? selectReturnType : modelClass;
            }
            return Pair.of((Object)new ListMapper(), (Object)cls);
        }
        if (ResultMapperFactory.isSimpleType(returnType)) {
            return Pair.of((Object)new SimpleMapper(), returnType);
        }
        if (ResultMapperFactory.isDateType(returnType)) {
            return Pair.of((Object)new DateMapper(), returnType);
        }
        if (ResultMapperFactory.isTimestampType(returnType)) {
            return Pair.of((Object)new TimestampMapper(), returnType);
        }
        if (BaseModel.class.equals(returnType)) {
            returnType = modelClass;
        }
        return Pair.of((Object)new BeanMapper(), (Object)returnType);
    }

    private static boolean isMapListType(Class<?> returnType) {
        if (!returnType.equals(List.class)) {
            return false;
        }
        Class genericType = ClassUtil.parseGenericType(returnType);
        return null != genericType && genericType.equals(Map.class);
    }

    private static boolean isTimestampType(Class<?> returnType) {
        return returnType.equals(Timestamp.class);
    }

    private static boolean isDateType(Class<?> returnType) {
        return returnType.equals(Date.class);
    }

    private static boolean isSimpleType(Class<?> returnType) {
        return returnType.isPrimitive() || returnType.equals(Integer.class) || returnType.equals(Long.class) || returnType.equals(Double.class) || returnType.equals(Float.class) || returnType.equals(Short.class) || returnType.equals(Boolean.class) || returnType.equals(String.class);
    }
}

