/*
 * Decompiled with CFR 0.152.
 */
package com.cory.db.jdbc.mapper;

import com.cory.constant.ErrorCode;
import com.cory.db.jdbc.mapper.SimpleValueResultMapper;
import com.cory.exception.CoryException;
import com.cory.util.DateUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampMapper
extends SimpleValueResultMapper {
    private static final Logger log = LoggerFactory.getLogger(TimestampMapper.class);

    @Override
    protected Object doSimpleMap(Object object, Class<?> returnType) {
        try {
            return new Timestamp(DateUtils.parseDate((String)object.toString()).getTime());
        }
        catch (ParseException e) {
            log.error("parse to timestamp fail", (Throwable)e);
            throw new CoryException(ErrorCode.DB_ERROR, new Object[]{"parse to timestamp fail: " + e.getMessage()});
        }
    }
}

