/*
 * Decompiled with CFR 0.152.
 */
package com.cory.db.processor;

import com.cory.db.config.CoryDbProperties;
import com.cory.db.datapermission.DataPermission;
import com.cory.db.jdbc.CoryDb;
import com.cory.db.jdbc.CoryDbProxy;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.Nullable;

public class CoryDaoFactoryBean<T>
implements FactoryBean<T> {
    private ApplicationContext ctx;
    private Class<T> cls;

    @Nullable
    public T getObject() throws Exception {
        CoryDb coryDb = (CoryDb)this.ctx.getBean(CoryDb.class);
        List<DataPermission> dataPermissionList = this.parseDataPermission();
        CoryDbProperties coryDbProperties = (CoryDbProperties)this.ctx.getBean(CoryDbProperties.class);
        return CoryDbProxy.newMapperProxy(this.cls, coryDb, coryDbProperties.isLogEnable(), dataPermissionList);
    }

    private List<DataPermission> parseDataPermission() {
        Map dataPermissionMap = this.ctx.getBeansOfType(DataPermission.class);
        if (MapUtils.isEmpty((Map)dataPermissionMap)) {
            return Lists.newArrayList();
        }
        return dataPermissionMap.values().stream().collect(Collectors.toList());
    }

    @Nullable
    public Class<?> getObjectType() {
        return this.cls;
    }

    public void setCtx(ApplicationContext ctx) {
        this.ctx = ctx;
    }

    public void setCls(Class<T> cls) {
        this.cls = cls;
    }
}

