/*
 * Decompiled with CFR 0.152.
 */
package com.cory.db.processor;

import com.cory.db.annotations.Dao;
import com.cory.db.processor.CoryDaoFactoryBean;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.util.AnnotatedTypeScanner;

public class CoryDbDaoProcessor
implements BeanDefinitionRegistryPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CoryDbDaoProcessor.class);
    private ApplicationContext applicationContext;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        log.info("cory db register bean definition start");
        AnnotatedTypeScanner scanner = new AnnotatedTypeScanner(true, new Class[]{Dao.class});
        Set set = scanner.findTypes(new String[]{"com.cory.dao"});
        if (CollectionUtils.isEmpty((Collection)set)) {
            log.info("no dao found in packages: com.cory.dao");
            return;
        }
        for (Class cls : set) {
            RootBeanDefinition bd = (RootBeanDefinition)BeanDefinitionBuilder.rootBeanDefinition((Class)cls).setScope("singleton").setLazyInit(true).getBeanDefinition();
            bd.setBeanClass(CoryDaoFactoryBean.class);
            bd.getPropertyValues().add("cls", (Object)cls);
            bd.getPropertyValues().add("ctx", (Object)this.applicationContext);
            beanDefinitionRegistry.registerBeanDefinition(StringUtils.capitalize((String)cls.getSimpleName()), (BeanDefinition)bd);
        }
        log.info("cory db register bean definition finish, registered {} DAO", (Object)set.size());
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

