/*
 * Decompiled with CFR 0.152.
 */
package ink.gfwl.jd.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import ink.gfwl.jd.base.BaseQueryParam;
import ink.gfwl.jd.config.RequestURL;
import ink.gfwl.jd.model.address.AddressCastModel;
import ink.gfwl.jd.model.address.AddressCheckModel;
import ink.gfwl.jd.model.address.AddressModel;
import ink.gfwl.jd.model.address.result.AddressCastResult;
import ink.gfwl.jd.util.HttpUtil;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AddressService
extends RequestURL {
    @Resource
    private BaseQueryParam baseQueryParam;

    public AddressModel getAddress(int level, Integer id) {
        Map<String, Object> params = this.baseQueryParam.getBaseQueryParam();
        String url = "";
        switch (level) {
            case 1: {
                url = "https://bizapi.jd.com/api/area/getProvince";
                break;
            }
            case 2: {
                params.put("id", String.valueOf(id));
                url = "https://bizapi.jd.com/api/area/getCity";
                break;
            }
            case 3: {
                params.put("id", String.valueOf(id));
                url = "https://bizapi.jd.com/api/area/getCounty";
                break;
            }
            case 4: {
                params.put("id", String.valueOf(id));
                url = "https://bizapi.jd.com/api/area/getTown";
                break;
            }
        }
        String rs = HttpUtil.httpPost(url, params);
        return (AddressModel)JSONObject.toJavaObject((JSON)JSON.parseObject((String)rs), AddressModel.class);
    }

    public AddressCheckModel checkAddress(Integer provinceId, Integer cityId, Integer countyId, Integer townId) {
        Map<String, Object> params = this.baseQueryParam.getBaseQueryParam();
        params.put("provinceId", provinceId);
        params.put("cityId", cityId);
        params.put("countyId", countyId);
        params.put("townId", townId);
        String rs = HttpUtil.httpPost("https://bizapi.jd.com/api/area/checkArea", params);
        return (AddressCheckModel)JSONObject.toJavaObject((JSON)JSON.parseObject((String)rs), AddressCheckModel.class);
    }

    public AddressCastModel addressCastJdAddress(String address) {
        Map<String, Object> params = this.baseQueryParam.getBaseQueryParam();
        params.put("address", address);
        String rs = HttpUtil.httpPost("https://bizapi.jd.com/api/area/getJDAddressFromAddress", params);
        return (AddressCastModel)JSONObject.toJavaObject((JSON)JSON.parseObject((String)rs), AddressCastModel.class);
    }

    public boolean simpleAddressCheck(String address) {
        AddressCastModel addressCastModel = this.addressCastJdAddress(address);
        if ("0000".equals(addressCastModel.getResultCode())) {
            AddressCastResult result = addressCastModel.getResult();
            AddressCheckModel addressCheckModel = this.checkAddress(result.getProvinceId(), result.getCityId(), result.getCountyId(), result.getTownId() == null ? 0 : result.getTownId());
            return addressCheckModel.getResult().isSuccess();
        }
        return false;
    }
}

